/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class SentryRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private final TranslationTextComponent modifyAll = Utils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
    private ItemStack srat;
    private IdButton[][] guiButtons = new IdButton[12][3];
    private ITextComponent[] names = new ITextComponent[12];
    private IdButton[] guiButtonsGlobal = new IdButton[3];
    private static final int MODE = 0;
    private static final int TARGETS = 1;
    private static final int UNBIND = 2;
    private int xSize = 440;
    private int ySize = 215;
    private static final int SENTRY_TRACKING_RANGE = 256;
    private int viewDistance;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();
    private final TranslationTextComponent notBound = Utils.localize("gui.securitycraft:srat.notBound", new Object[0]);
    private final ITextComponent[] lines = new ITextComponent[12];
    private final int[] lengths = new int[12];

    public SentryRemoteAccessToolScreen(ItemStack item, int viewDistance) {
        super((ITextComponent)new TranslationTextComponent(item.func_77977_a()));
        this.srat = item;
        this.viewDistance = viewDistance;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        int paddingX = 22;
        int paddingY = 25;
        int[] coords = null;
        int id = 0;
        boolean foundSentry = false;
        int[] modeTextureX = new int[]{0, 16, 32};
        int[] targetTextureX = new int[]{48, 64, 80};
        int[] yStarts = new int[]{0, 0, 0};
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.xSize / 2;
            int y = (i % 6 + 1) * 30 + paddingY;
            coords = this.getSentryCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                int btnX = startX + j * paddingX + 147 + x;
                int btnY = startY + y - 48;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformed);
                        this.guiButtons[i][j].field_230693_o_ = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformed);
                        this.guiButtons[i][j].field_230693_o_ = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new IdButton(id++, btnX, btnY, 20, 20, "X", this::clickUnbind);
                        this.guiButtons[i][j].field_230693_o_ = false;
                    }
                }
                this.func_230480_a_((Widget)this.guiButtons[i][j]);
            }
            BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] != 0 || coords[1] != 0 || coords[2] != 0) {
                this.guiButtons[i][2].field_230693_o_ = true;
                if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_195588_v(sentryPos) && this.isSentryVisibleToPlayer(sentryPos)) {
                    List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217357_a(SentryEntity.class, new AxisAlignedBB(sentryPos));
                    if (!sentries.isEmpty()) {
                        SentryEntity sentry = (SentryEntity)((Object)sentries.get(0));
                        SentryEntity.SentryMode mode = sentry.getMode();
                        if (sentry.func_145818_k_()) {
                            TranslationTextComponent line = Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]));
                            int nameWidth = this.field_230712_o_.func_238414_a_((ITextProperties)sentry.func_200201_e());
                            int nameX = startX + this.xSize / 4 - nameWidth + 33 + i / 6 * this.xSize / 2;
                            int nameY = startY + i % 6 * 30 + 7;
                            TextHoverChecker posTooltipText = new TextHoverChecker(nameY + 4, nameY + 18, nameX, nameX + nameWidth + 2, (ITextComponent)line);
                            this.names[i] = sentry.func_200201_e();
                            this.hoverCheckers.add(posTooltipText);
                        }
                        this.guiButtons[i][0].field_230693_o_ = true;
                        this.guiButtons[i][1].field_230693_o_ = mode != SentryEntity.SentryMode.IDLE;
                        this.guiButtons[i][2].field_230693_o_ = true;
                        ((TogglePictureButton)this.guiButtons[i][0]).setCurrentIndex(mode.ordinal() / 3);
                        ((TogglePictureButton)this.guiButtons[i][1]).setCurrentIndex(mode.ordinal() % 3);
                        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtons[i][0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]))));
                        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtons[i][1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]))));
                        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtons[i][2], (ITextComponent)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                        foundSentry = true;
                    } else {
                        this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
                        for (int j = 0; j < 3; ++j) {
                            this.guiButtons[i][j].field_230693_o_ = false;
                        }
                    }
                } else {
                    for (int j = 0; j < 2; ++j) {
                        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtons[i][j], (ITextComponent)Utils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
                    }
                    this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtons[i][2], (ITextComponent)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                }
            }
            this.lines[i] = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? this.notBound : (this.names[i] != null ? this.names[i] : Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])));
            this.lengths[i] = this.field_230712_o_.func_238414_a_((ITextProperties)this.lines[i]);
        }
        this.guiButtonsGlobal[0] = new TogglePictureButton(1000, startX + 260, startY + 188, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[1] = new TogglePictureButton(1001, startX + 22 + 260, startY + 188, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[2] = new IdButton(1002, startX + 44 + 260, startY + 188, 20, 20, "X", this::clickGlobalUnbind);
        for (int j = 0; j < 3; ++j) {
            this.guiButtonsGlobal[j].field_230693_o_ = foundSentry;
            this.func_230480_a_((Widget)this.guiButtonsGlobal[j]);
        }
        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtonsGlobal[0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]))));
        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtonsGlobal[1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]))));
        this.hoverCheckers.add(new TextHoverChecker((Widget)this.guiButtonsGlobal[2], (ITextComponent)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        SentryRemoteAccessToolScreen.func_238463_a_((MatrixStack)matrix, (int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)256);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (float)(startX + 5), (float)(startY - 25 + 13), 0xFF0000);
        for (int i = 0; i < 12; ++i) {
            this.field_230712_o_.func_243248_b(matrix, this.lines[i], (float)(startX + this.xSize / 4 - this.lengths[i] + 35 + i / 6 * this.xSize / 2), (float)(startY + i % 6 * 30 + 13), 0x404040);
        }
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.modifyAll, (float)(startX + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.modifyAll) + 25), (float)(startY + 194), 0x404040);
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
            this.func_238652_a_(matrix, chc.getName(), mouseX, mouseY);
        }
    }

    protected void performSingleAction(int sentry, int mode, int targets) {
        int[] coords = this.getSentryCoordinates(sentry);
        List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217357_a(SentryEntity.class, new AxisAlignedBB(new BlockPos(coords[0], coords[1], coords[2])));
        if (!sentries.isEmpty()) {
            int resultingMode = Math.max(0, Math.min(targets + mode * 3, 6));
            this.guiButtons[sentry][1].field_230693_o_ = SentryEntity.SentryMode.values()[resultingMode] != SentryEntity.SentryMode.IDLE;
            ((SentryEntity)((Object)sentries.get(0))).toggleMode((PlayerEntity)Minecraft.func_71410_x().field_71439_g, resultingMode, false);
            SecurityCraft.channel.sendToServer((Object)new SetSentryMode(((SentryEntity)((Object)sentries.get(0))).func_233580_cy_(), resultingMode));
        }
    }

    private void clickUnbind(IdButton button) {
        this.unbindSentry(button.id / 3);
    }

    private void clickGlobalUnbind(IdButton button) {
        for (int i = 0; i < 12; ++i) {
            this.unbindSentry(i);
        }
    }

    private void unbindSentry(int sentry) {
        int i;
        int[] coords = this.getSentryCoordinates(sentry);
        this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
        for (i = 0; i < 3; ++i) {
            this.guiButtons[sentry][i].field_230693_o_ = false;
        }
        for (i = 0; i < this.guiButtons.length; ++i) {
            if (!this.guiButtons[i][2].field_230693_o_) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtonsGlobal[i].field_230693_o_ = false;
        }
    }

    protected void actionPerformed(IdButton button) {
        int mode;
        int sentry = button.id / 3;
        int type = button.id % 3;
        int targets = mode = ((TogglePictureButton)button).getCurrentIndex();
        if (type == 0) {
            targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
        } else if (type == 1) {
            mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
        }
        this.performSingleAction(sentry, mode, targets);
    }

    protected void actionPerformedGlobal(IdButton button) {
        for (int i = 0; i < this.field_230710_m_.size() / 3; ++i) {
            Widget widget = (Widget)this.field_230710_m_.get(i * 3);
            if (!(widget instanceof IdButton) || this.getSentryCoordinates(i)[1] == 0) continue;
            int sentry = ((IdButton)((Object)this.field_230710_m_.get((int)(i * 3)))).id / 3;
            int mode = button.id == this.guiButtonsGlobal[0].id ? ((TogglePictureButton)this.guiButtonsGlobal[0]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
            int targets = button.id == this.guiButtonsGlobal[1].id ? ((TogglePictureButton)this.guiButtonsGlobal[1]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
            ((TogglePictureButton)this.guiButtons[sentry][0]).setCurrentIndex(mode);
            ((TogglePictureButton)this.guiButtons[sentry][1]).setCurrentIndex(targets);
            this.performSingleAction(sentry, mode, targets);
        }
    }

    private int[] getSentryCoordinates(int sentry) {
        if (this.srat.func_77973_b() != null && this.srat.func_77973_b() == SCContent.REMOTE_ACCESS_SENTRY.get() && this.srat.func_77978_p() != null && this.srat.func_77978_p().func_74759_k("sentry" + ++sentry) != null && this.srat.func_77978_p().func_74759_k("sentry" + sentry).length > 0) {
            return this.srat.func_77978_p().func_74759_k("sentry" + sentry);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(stack));
            return;
        }
    }

    private boolean isSentryVisibleToPlayer(BlockPos sentryPos) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.func_226277_ct_() - (double)sentryPos.func_177958_n();
        double d1 = player.func_226281_cx_() - (double)sentryPos.func_177952_p();
        int i = Math.min(256, this.viewDistance) - 1;
        return d0 >= (double)(-i) && d0 <= (double)i && d1 >= (double)(-i) && d1 <= (double)i;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.func_231164_f_();
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

