/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketWallBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedCrystalQuartzPillar;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedPillarBlock;
import net.geforcemods.securitycraft.containers.BlockPocketManagerContainer;
import net.geforcemods.securitycraft.inventory.InsertOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.BlockPocketTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPocketManagerTileEntity
extends CustomizableTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
ILockable {
    public static final int RENDER_DISTANCE = 100;
    private static final int BLOCK_PLACEMENTS_PER_TICK = 4;
    public boolean enabled = false;
    public boolean showOutline = false;
    public int size = 5;
    public int autoBuildOffset = 0;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();
    protected NonNullList<ItemStack> storage = NonNullList.func_191197_a((int)56, (Object)ItemStack.field_190927_a);
    private LazyOptional<IItemHandler> storageHandler;
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private List<Pair<BlockPos, BlockState>> placeQueue = new ArrayList<Pair<BlockPos, BlockState>>();
    private boolean shouldPlaceBlocks = false;

    public BlockPocketManagerTileEntity() {
        super(SCContent.teTypeBlockPocketManager);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.shouldPlaceBlocks) {
            PlayerEntity owner = PlayerUtils.getPlayerFromName(this.getOwner().getName());
            boolean isCreative = owner.func_184812_l_();
            boolean placed4 = true;
            block0: for (int i = 0; i < 4; ++i) {
                Pair<BlockPos, BlockState> toPlace;
                BlockState stateInWorld;
                do {
                    if (this.placeQueue.isEmpty()) {
                        placed4 = false;
                        break block0;
                    }
                    toPlace = this.placeQueue.remove(0);
                    if (((BlockState)toPlace.getRight()).func_177230_c() instanceof IBlockPocket) continue;
                    throw new IllegalStateException(String.format("Tried to automatically place non-block pocket block \"%s\"! This mustn't happen!", ((BlockState)toPlace.getRight()).func_177230_c().func_149739_a()));
                } while ((stateInWorld = this.field_145850_b.func_180495_p((BlockPos)toPlace.getLeft())) == toPlace.getRight());
                if (stateInWorld.func_185904_a().func_76222_j()) {
                    BlockPos pos = (BlockPos)toPlace.getLeft();
                    BlockState stateToPlace = (BlockState)toPlace.getRight();
                    SoundType soundType = stateToPlace.func_215695_r();
                    if (!isCreative) {
                        for (int k = 0; k < this.storage.size(); ++k) {
                            ItemStack stackToCheck = (ItemStack)this.storage.get(k);
                            if (stackToCheck.func_190926_b() || ((BlockItem)stackToCheck.func_77973_b()).func_179223_d() != stateToPlace.func_177230_c()) continue;
                            stackToCheck.func_190918_g(1);
                            break;
                        }
                    }
                    this.field_145850_b.func_175656_a(pos, stateToPlace);
                    this.field_145850_b.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
                    TileEntity te = this.field_145850_b.func_175625_s(pos);
                    if (!(te instanceof OwnableTileEntity)) continue;
                    ((OwnableTileEntity)te).setOwner(this.getOwner().getUUID(), this.getOwner().getName());
                    continue;
                }
                PlayerUtils.sendMessageToPlayer(owner, (IFormattableTextComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)new TranslationTextComponent("messages.securitycraft:blockpocket.assemblyFailed", new Object[]{this.getFormattedRelativeCoordinates((BlockPos)toPlace.getLeft(), (Direction)this.func_195044_w().func_177229_b((Property)BlockPocketManagerBlock.FACING)), new TranslationTextComponent(stateInWorld.func_177230_c().func_149739_a())}), TextFormatting.DARK_AQUA);
                placed4 = false;
                break;
            }
            if (!placed4) {
                if (!this.placeQueue.isEmpty()) {
                    this.placeQueue.clear();
                } else {
                    this.setWalls(!this.hasModule(ModuleType.DISGUISE));
                    PlayerUtils.sendMessageToPlayer(owner, (IFormattableTextComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)new TranslationTextComponent("messages.securitycraft:blockpocket.assembled"), TextFormatting.DARK_AQUA);
                }
                this.shouldPlaceBlocks = false;
            }
        }
    }

    public TranslationTextComponent enableMultiblock() {
        if (!this.enabled) {
            TileEntity te;
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, true, this.size));
            }
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
            Direction managerFacing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.func_176746_e();
            Direction right = left.func_176734_d();
            Direction back = left.func_176746_e();
            boolean lowest = false;
            int highest = this.size - 1;
            BlockPos pos = this.func_174877_v().func_185334_h();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int offset = 0;
            if (!(this.field_145850_b.func_180495_p(pos.func_177972_a(left)).func_177230_c() instanceof IBlockPocket)) {
                offset = -this.autoBuildOffset + this.size / 2;
                pos = pos.func_177967_a(left, offset);
            } else {
                for (int i = 1; i < this.size - 1; ++i) {
                    if (this.field_145850_b.func_180495_p(pos.func_177967_a(left, i)).func_177230_c() instanceof ReinforcedRotatedCrystalQuartzPillar) continue;
                    offset = i;
                    pos = pos.func_177967_a(left, offset);
                    break;
                }
                if (offset == 0) {
                    offset = -this.autoBuildOffset + this.size / 2;
                    pos = pos.func_177967_a(left, offset);
                }
            }
            BlockPos startingPos = pos.func_185334_h();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.func_177967_a(right, xi);
                        BlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                        if (currentState.func_177230_c() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.func_174877_v())) {
                            return new TranslationTextComponent("messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            Direction.Axis typeToCheckFor;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).func_149739_a())});
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    if (currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                    }
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_149739_a())});
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    if (currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                    }
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_149739_a())});
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock)) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).func_149739_a())});
                                }
                                floor.add(currentPos);
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != Direction.Axis.Y) {
                                if (currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_149739_a())});
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock)) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).func_149739_a())});
                                }
                                sides.add(currentPos);
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock)) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a()), new TranslationTextComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).func_149739_a())});
                                }
                                sides.add(currentPos);
                            }
                        }
                        te = (OwnableTileEntity)this.field_145850_b.func_175625_s(currentPos);
                        if (!this.getOwner().owns(new IOwnable[]{te})) {
                            return new TranslationTextComponent("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.floor = floor;
            this.enabled = true;
            this.autoBuildOffset = -offset + this.size / 2;
            for (BlockPos blockPos : blocks) {
                te = this.field_145850_b.func_175625_s(blockPos);
                if (!(te instanceof BlockPocketTileEntity)) continue;
                ((BlockPocketTileEntity)te).setManager(this);
            }
            for (BlockPos blockPos : floor) {
                this.field_145850_b.func_175656_a(blockPos, (BlockState)this.field_145850_b.func_180495_p(blockPos).func_206870_a((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(true)));
            }
            this.setWalls(!this.hasModule(ModuleType.DISGUISE));
            return new TranslationTextComponent("messages.securitycraft:blockpocket.activated");
        }
        return null;
    }

    public IFormattableTextComponent autoAssembleMultiblock() {
        if (!this.enabled) {
            BlockState currentState;
            BlockPos currentPos;
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.sendToServer((Object)new AssembleBlockPocket(this, this.size));
            }
            Direction managerFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.func_176746_e();
            Direction right = left.func_176734_d();
            Direction back = left.func_176746_e();
            boolean lowest = false;
            int half = (this.size - 1) / 2 - this.autoBuildOffset;
            int highest = this.size - 1;
            BlockPos pos = this.func_174877_v().func_185334_h();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.func_177967_a(right, -half);
            BlockPos startingPos = pos.func_185334_h();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.func_177967_a(right, xi);
                        currentState = this.field_145850_b.func_180495_p(currentPos);
                        boolean replaceable = currentState.func_185904_a().func_76222_j();
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            Direction.Axis typeToCheckFor;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() && !replaceable) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.func_177230_c() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.func_177230_c() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.func_177229_b((Property)BlockStateProperties.field_208148_A) != Direction.Axis.Y) {
                                return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                            }
                            if (replaceable) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslationTextComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        }
                        if (this.field_145850_b.func_175625_s(currentPos) instanceof OwnableTileEntity) {
                            OwnableTileEntity te = (OwnableTileEntity)this.field_145850_b.func_175625_s(currentPos);
                            if (!this.getOwner().owns(te)) {
                                return new TranslationTextComponent("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslationTextComponent(currentState.func_177230_c().func_199767_j().func_77658_a())});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return new TranslationTextComponent("messages.securitycraft:blockpocket.alreadyAssembled");
            }
            pos = this.func_174877_v().func_185334_h().func_177967_a(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.func_177967_a(right, xi);
                        currentState = this.field_145850_b.func_180495_p(currentPos);
                        if (currentState.func_177230_c() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.func_174877_v())) {
                            return new TranslationTextComponent("messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            Direction.Axis typeToPlace;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).func_176223_P()));
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_176223_P().func_206870_a(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace)));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_176223_P().func_206870_a(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace)));
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).func_176223_P()));
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).func_176223_P().func_206870_a(ReinforcedRotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y)));
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).func_176223_P()));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).func_176223_P()));
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            this.shouldPlaceBlocks = true;
            return null;
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, false, this.size));
                PlayerUtils.sendMessageToPlayer(ClientHandler.getClientPlayer(), (IFormattableTextComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]), TextFormatting.DARK_AQUA, true);
            }
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (!(te instanceof BlockPocketTileEntity)) continue;
                ((BlockPocketTileEntity)te).removeManager();
            }
            for (BlockPos pos : this.floor) {
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (!state.func_235901_b_((Property)BlockPocketWallBlock.SOLID)) continue;
                this.field_145850_b.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.hasModule(ModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
        }
    }

    private TranslationTextComponent getFormattedRelativeCoordinates(BlockPos pos, Direction managerFacing) {
        int offsetLeft;
        int offsetBehind;
        BlockPos difference = pos.func_177973_b((Vector3i)this.field_174879_c);
        int offsetAbove = difference.func_177956_o();
        ArrayList<TranslationTextComponent> components = new ArrayList<TranslationTextComponent>();
        switch (managerFacing) {
            case NORTH: {
                offsetBehind = difference.func_177952_p();
                offsetLeft = difference.func_177958_n();
                break;
            }
            case SOUTH: {
                offsetBehind = -difference.func_177952_p();
                offsetLeft = -difference.func_177958_n();
                break;
            }
            case WEST: {
                offsetBehind = difference.func_177958_n();
                offsetLeft = -difference.func_177952_p();
                break;
            }
            case EAST: {
                offsetBehind = -difference.func_177958_n();
                offsetLeft = difference.func_177952_p();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Block Pocket Manager direction: " + managerFacing.name());
            }
        }
        if (offsetLeft > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksLeft", offsetLeft));
        } else if (offsetLeft < 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksRight", -offsetLeft));
        }
        if (offsetBehind > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksBehind", offsetBehind));
        }
        if (offsetAbove > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksAbove", offsetAbove));
        }
        return Utils.localize("messages.securitycraft:blockpocket.position." + components.size(), components.toArray());
    }

    public void toggleOutline() {
        this.showOutline = !this.showOutline;
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            BlockState state = this.field_145850_b.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockPocketWallBlock)) continue;
            this.field_145850_b.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockPocketWallBlock.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isPlacingBlocks()) {
                return this.getInsertOnlyHandler().cast();
            }
            return BlockUtils.getProtectedCapability(side, this, () -> this.getStorageHandler(), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.func_175667_e(this.field_174879_c) && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != SCContent.BLOCK_POCKET_MANAGER.get()) {
            this.disableMultiblock();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (this.enabled && module == ModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (this.enabled && module == ModuleType.DISGUISE) {
            this.setWalls(true);
        } else if (module == ModuleType.STORAGE) {
            this.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                }
            });
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        int i;
        tag.func_74757_a("BlockPocketEnabled", this.enabled);
        tag.func_74757_a("ShowOutline", this.showOutline);
        tag.func_74768_a("Size", this.size);
        tag.func_74768_a("AutoBuildOffset", this.autoBuildOffset);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.storage);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.func_74772_a("BlocksList" + i, this.blocks.get(i).func_218275_a());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.func_74772_a("WallsList" + i, this.walls.get(i).func_218275_a());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.func_74772_a("FloorList" + i, this.floor.get(i).func_218275_a());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        int i = 0;
        super.func_230337_a_(state, tag);
        this.enabled = tag.func_74767_n("BlockPocketEnabled");
        this.showOutline = tag.func_74767_n("ShowOutline");
        this.size = tag.func_74762_e("Size");
        this.autoBuildOffset = tag.func_74762_e("AutoBuildOffset");
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.storage);
        while (tag.func_74764_b("BlocksList" + i)) {
            this.blocks.add(BlockPos.func_218283_e((long)tag.func_74763_f("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("WallsList" + i)) {
            this.walls.add(BlockPos.func_218283_e((long)tag.func_74763_f("WallsList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("FloorList" + i)) {
            this.floor.add(BlockPos.func_218283_e((long)tag.func_74763_f("FloorList" + i)));
            ++i;
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.STORAGE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new BlockPocketManagerContainer(windowId, this.field_145850_b, this.field_174879_c, inv);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    public LazyOptional<IItemHandler> getStorageHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = LazyOptional.of(() -> new ItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerTileEntity.isItemValid(stack);
                }
            });
        }
        return this.storageHandler;
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerTileEntity.isItemValid(stack);
                }
            });
        }
        return this.insertOnlyHandler;
    }

    public boolean isPlacingBlocks() {
        return this.shouldPlaceBlocks;
    }

    public static boolean isItemValid(ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            return block == SCContent.BLOCK_POCKET_WALL.get() || block == SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() || block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get();
        }
        return false;
    }
}

