/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.entity.IMSBombEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class IMSTileEntity
extends CustomizableTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private Option.IntOption range = new Option.IntOption(() -> ((IMSTileEntity)this).func_174877_v(), "range", 12, 1, 30, 1, true);
    private int bombsRemaining = 4;
    private IMSTargetingMode targetingMode = IMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public IMSTileEntity() {
        super(SCContent.teTypeIms);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            int mineCount = (Integer)this.func_195044_w().func_177229_b((Property)IMSBlock.MINES);
            if (mineCount - 1 >= 0 && mineCount <= 4) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)IMSBlock.MINES, (Comparable)Integer.valueOf(mineCount - 1)));
            }
            this.updateBombCount = false;
        }
        if (this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine();
        }
    }

    private void launchMine() {
        if (this.bombsRemaining > 0) {
            List players;
            List mobs;
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)((Integer)this.range.get()).intValue());
            LivingEntity target = null;
            if (!(this.targetingMode != IMSTargetingMode.MOBS && this.targetingMode != IMSTargetingMode.PLAYERS_AND_MOBS || (mobs = this.field_145850_b.func_175647_a(MonsterEntity.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e) && this.canAttackEntity((LivingEntity)e))).isEmpty())) {
                target = (LivingEntity)mobs.get(0);
            }
            if (!(target != null || this.targetingMode != IMSTargetingMode.PLAYERS && this.targetingMode != IMSTargetingMode.PLAYERS_AND_MOBS || (players = this.field_145850_b.func_175647_a(PlayerEntity.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e) && this.canAttackEntity((LivingEntity)e))).isEmpty())) {
                target = (LivingEntity)players.get(0);
            }
            if (target != null) {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = target.func_226277_ct_() - (double)this.field_174879_c.func_177958_n();
                double accelerationY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - (double)this.field_174879_c.func_177956_o() - (double)launchHeight;
                double accelerationZ = target.func_226281_cx_() - (double)this.field_174879_c.func_177952_p();
                this.field_145850_b.func_217376_c((Entity)new IMSBombEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + addToX, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
            }
        }
    }

    public boolean canAttackEntity(LivingEntity entity) {
        return entity != null && (!(entity instanceof PlayerEntity) || !this.getOwner().isOwner((PlayerEntity)entity) && !((PlayerEntity)entity).func_184812_l_() && !((PlayerEntity)entity).func_175149_v()) && !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)entity);
    }

    private int getLaunchHeight() {
        BlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(height))) == null || state.isAir((IBlockReader)this.func_145831_w(), this.func_174877_v())); ++height) {
        }
        return height;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("bombsRemaining", this.bombsRemaining);
        tag.func_74768_a("targetingOption", this.targetingMode.ordinal());
        tag.func_74757_a("updateBombCount", this.updateBombCount);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.bombsRemaining = tag.func_74762_e("bombsRemaining");
        this.targetingMode = IMSTargetingMode.values()[tag.func_74762_e("targetingOption")];
        this.updateBombCount = tag.func_74767_n("updateBombCount");
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public IMSTargetingMode getTargetingMode() {
        return this.targetingMode;
    }

    public void setTargetingMode(IMSTargetingMode targetingOption) {
        this.targetingMode = targetingOption;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new GenericTEContainer(SCContent.cTypeIMS, windowId, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    public int getAttackInterval() {
        return this.hasModule(ModuleType.SPEED) ? 40 : 80;
    }

    public static enum IMSTargetingMode {
        PLAYERS,
        PLAYERS_AND_MOBS,
        MOBS;

    }
}

