/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeyPanelBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeyPanelTileEntity
extends CustomizableTileEntity
implements IPasswordProtected,
ILockable {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            KeyPanelTileEntity.this.field_145850_b.func_175656_a(KeyPanelTileEntity.this.field_174879_c, (BlockState)KeyPanelTileEntity.this.func_195044_w().func_206870_a((Property)KeyPanelBlock.POWERED, (Comparable)this.get()));
            KeyPanelTileEntity.this.field_145850_b.func_195593_d(KeyPanelTileEntity.this.field_174879_c, (Block)SCContent.KEY_PANEL_BLOCK.get());
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeyPanelTileEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);

    public KeyPanelTileEntity() {
        super(SCContent.teTypeKeyPanel);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.passcode = tag.func_74779_i("passcode");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength};
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.func_195044_w().func_177230_c() instanceof KeyPanelBlock) {
            ((KeyPanelBlock)this.func_195044_w().func_177230_c()).activate(this.func_195044_w(), this.field_145850_b, this.field_174879_c, (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeCheckPassword, windowId, KeyPanelTileEntity.this.field_145850_b, KeyPanelTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeyPanelTileEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeSetPassword, windowId, KeyPanelTileEntity.this.field_145850_b, KeyPanelTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeyPanelTileEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, PlayerEntity player) {
        if (!((Boolean)state.func_177229_b((Property)KeyPanelBlock.POWERED)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

