/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeypadChestTileEntity
extends ChestTileEntity
implements IPasswordProtected,
IOwnable,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private String passcode;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public KeypadChestTileEntity() {
        super(SCContent.teTypeKeypadChest);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.owner != null) {
            this.owner.write(tag, false);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.passcode = tag.func_74779_i("passcode");
        this.owner.read(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public ITextComponent func_213907_g() {
        return Utils.localize("block.securitycraft.keypad_chest", new Object[0]);
    }

    protected void func_195482_p() {
        super.func_195482_p();
        if (this.hasModule(ModuleType.REDSTONE)) {
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, (Block)SCContent.KEYPAD_CHEST.get(), Direction.DOWN);
        }
    }

    public int getNumPlayersUsing() {
        return this.field_145987_o;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (TileEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((IInventory)this));
        }
        return this.insertOnlyHandler;
    }

    public LazyOptional<IItemHandler> getHandlerForSentry(SentryEntity entity) {
        if (entity.getOwner().owns(this)) {
            return super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.func_70301_a(slot);
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.func_195044_w().func_177230_c() instanceof KeypadChestBlock && !this.isBlocked()) {
            ((KeypadChestBlock)this.func_195044_w().func_177230_c()).activate(this.func_195044_w(), this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.isBlocked()) {
            return;
        }
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeCheckPassword, windowId, KeypadChestTileEntity.this.field_145850_b, KeypadChestTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeypadChestTileEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeSetPassword, windowId, KeypadChestTileEntity.this.field_145850_b, KeypadChestTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return KeypadChestTileEntity.super.func_145748_c_();
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player) {
        this.activate(player);
        return true;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        this.addOrRemoveModuleFromAttached(stack, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        this.addOrRemoveModuleFromAttached(stack, true);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        KeypadChestTileEntity offsetTe;
        if (option instanceof Option.BooleanOption && (offsetTe = this.findOther()) != null) {
            offsetTe.setSendsMessages((Boolean)((Option.BooleanOption)option).get());
        }
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove) {
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ModuleItem)) {
            return;
        }
        KeypadChestTileEntity offsetTe = this.findOther();
        if (offsetTe != null) {
            if (remove) {
                offsetTe.removeModule(((ModuleItem)module.func_77973_b()).getModuleType());
            } else {
                offsetTe.insertModule(module);
            }
        }
    }

    public KeypadChestTileEntity findOther() {
        BlockState state = this.func_195044_w();
        ChestType type = (ChestType)state.func_177229_b((Property)KeypadChestBlock.field_196314_b);
        if (type != ChestType.SINGLE) {
            TileEntity offsetTe;
            ChestType offsetType;
            BlockPos offsetPos = this.field_174879_c.func_177972_a(ChestBlock.func_196311_i((BlockState)state));
            BlockState offsetState = this.field_145850_b.func_180495_p(offsetPos);
            if (state.func_177230_c() == offsetState.func_177230_c() && (offsetType = (ChestType)offsetState.func_177229_b((Property)KeypadChestBlock.field_196314_b)) != ChestType.SINGLE && type != offsetType && state.func_177229_b((Property)KeypadChestBlock.field_176459_a) == offsetState.func_177229_b((Property)KeypadChestBlock.field_176459_a) && (offsetTe = this.field_145850_b.func_175625_s(offsetPos)) instanceof KeypadChestTileEntity) {
                return (KeypadChestTileEntity)offsetTe;
            }
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public boolean isBlocked() {
        for (Direction dir : Direction.Plane.HORIZONTAL.func_239636_a_().collect(Collectors.toList())) {
            BlockPos pos = this.func_174877_v().func_177972_a(dir);
            if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof KeypadChestBlock) || !KeypadChestBlock.isBlocked(this.field_145850_b, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return KeypadChestBlock.isBlocked(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public void setSendsMessages(boolean value) {
        this.sendMessage.setValue(value);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }
}

