/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.LinkableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.network.PacketDistributor;

public class LaserBlockTileEntity
extends LinkableTileEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockTileEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockTileEntity() {
        super(SCContent.teTypeLaserBlock);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)this.func_195044_w().func_177230_c()).setLaser(this.field_145850_b, this.field_174879_c);
        } else {
            LaserBlock.destroyAdjacentLasers((IWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableTileEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (!this.field_145850_b.field_72995_K && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.field_174879_c, true, stack));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (!this.field_145850_b.field_72995_K && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.field_174879_c, false, stack));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_BLOCK_RL, (Object)this.func_195044_w().func_177230_c().getRegistryName()).build();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

