/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.ProtectoBlock;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class ProtectoTileEntity
extends DisguisableTileEntity
implements ITickableTileEntity {
    private static final int ATTACK_RANGE = 10;
    private static final int SLOW_SPEED = 200;
    private static final int FAST_SPEED = 100;
    private int cooldown = 0;
    private int ticksBetweenAttacks = this.hasModule(ModuleType.SPEED) ? 100 : 200;

    public ProtectoTileEntity() {
        super(SCContent.teTypeProtecto);
    }

    public void func_73660_a() {
        if (this.cooldown++ < this.ticksBetweenAttacks) {
            return;
        }
        if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_175710_j(this.field_174879_c)) {
            List entities = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(10.0));
            if (!((Boolean)this.func_195044_w().func_177229_b((Property)ProtectoBlock.ACTIVATED)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            }
            if (entities.size() != 0) {
                boolean shouldDeactivate = false;
                for (LivingEntity entity : entities) {
                    PlayerEntity player;
                    if (entity instanceof SentryEntity || EntityUtils.isInvisible(entity) || entity instanceof PlayerEntity && ((player = (PlayerEntity)entity).func_184812_l_() || player.func_175149_v() || this.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)this, (Entity)entity))) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        WorldUtils.spawnLightning(this.field_145850_b, entity.func_213303_ch(), false);
                    }
                    shouldDeactivate = true;
                }
                if (shouldDeactivate) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                }
            }
            this.cooldown = 0;
        } else if (((Boolean)this.func_195044_w().func_177229_b((Property)ProtectoBlock.ACTIVATED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == ModuleType.SPEED) {
            this.ticksBetweenAttacks = 100;
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.SPEED) {
            this.ticksBetweenAttacks = 200;
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }
}

