/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AabbHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;

public class ReinforcedPistonTileEntity
extends TileEntity
implements ITickableTileEntity,
IOwnable {
    private BlockState pistonState;
    private CompoundNBT tileEntityTag;
    private Direction pistonFacing;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    private static final ThreadLocal<Direction> MOVING_ENTITY = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;
    private int deathTicks;
    private Owner owner = new Owner();

    public ReinforcedPistonTileEntity() {
        super(SCContent.teTypeReinforcedPiston);
    }

    public ReinforcedPistonTileEntity(BlockState pistonState, CompoundNBT tag, Direction pistonFacing, boolean extending, boolean shouldHeadBeRendered) {
        super(SCContent.teTypeReinforcedPiston);
        this.pistonState = pistonState;
        this.tileEntityTag = tag;
        this.pistonFacing = pistonFacing;
        this.extending = extending;
        this.shouldHeadBeRendered = shouldHeadBeRendered;
        this.owner = Owner.fromCompound(tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getFacing() {
        return this.pistonFacing;
    }

    public boolean shouldPistonHeadBeRendered() {
        return this.shouldHeadBeRendered;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return MathHelper.func_219799_g((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    public float getOffsetX(float ticks) {
        return (float)this.pistonFacing.func_82601_c() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.pistonFacing.func_96559_d() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.pistonFacing.func_82599_e() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.shouldPistonHeadBeRendered() && this.pistonState.func_177230_c() instanceof ReinforcedPistonBlock ? (BlockState)((BlockState)((Block)SCContent.REINFORCED_PISTON_HEAD.get()).func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)(this.pistonState.func_177230_c() == SCContent.REINFORCED_STICKY_PISTON.get() ? PistonType.STICKY : PistonType.DEFAULT))).func_206870_a((Property)PistonHeadBlock.field_176387_N, this.pistonState.func_177229_b((Property)PistonBlock.field_176387_N)) : this.pistonState;
    }

    private void moveCollidedEntities(float progress) {
        AxisAlignedBB boundingBox;
        List list;
        Direction direction = this.getMotionDirection();
        double d0 = progress - this.progress;
        VoxelShape collisionShape = this.getCollisionRelatedBlockState().func_196952_d((IBlockReader)this.field_145850_b, this.func_174877_v());
        if (!collisionShape.func_197766_b() && !(list = this.field_145850_b.func_72839_b((Entity)null, AabbHelper.func_227019_a_((AxisAlignedBB)(boundingBox = this.moveByPositionAndProgress(collisionShape.func_197752_a())), (Direction)direction, (double)d0).func_111270_a(boundingBox))).isEmpty()) {
            List boundingBoxes = collisionShape.func_197756_d();
            boolean isSlimeBlock = this.pistonState.isSlimeBlock();
            Iterator iterator = list.iterator();
            while (true) {
                AxisAlignedBB entityBoundingBox;
                AxisAlignedBB aabb;
                AxisAlignedBB movementArea;
                if (!iterator.hasNext()) {
                    return;
                }
                Entity entity = (Entity)iterator.next();
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                if (isSlimeBlock) {
                    if (entity instanceof ServerPlayerEntity) continue;
                    Vector3d vector3d = entity.func_213322_ci();
                    double x = vector3d.field_72450_a;
                    double y = vector3d.field_72448_b;
                    double z = vector3d.field_72449_c;
                    switch (direction.func_176740_k()) {
                        case X: {
                            x = direction.func_82601_c();
                            break;
                        }
                        case Y: {
                            y = direction.func_96559_d();
                            break;
                        }
                        case Z: {
                            z = direction.func_82599_e();
                        }
                    }
                    entity.func_213293_j(x, y, z);
                }
                double movement = 0.0;
                Iterator iterator2 = boundingBoxes.iterator();
                while (!(!iterator2.hasNext() || (movementArea = AabbHelper.func_227019_a_((AxisAlignedBB)this.moveByPositionAndProgress(aabb = (AxisAlignedBB)iterator2.next()), (Direction)direction, (double)d0)).func_72326_a(entityBoundingBox = entity.func_174813_aQ()) && (movement = Math.max(movement, ReinforcedPistonTileEntity.getMovement(movementArea, direction, entityBoundingBox))) >= d0)) {
                }
                if (movement <= 0.0) continue;
                movement = Math.min(movement, d0) + 0.01;
                ReinforcedPistonTileEntity.pushEntity(direction, entity, movement, direction);
                if (this.extending || !this.shouldHeadBeRendered) continue;
                this.fixEntityWithinPistonBase(entity, direction, d0);
            }
        }
    }

    private static void pushEntity(Direction direction, Entity entity, double progress, Direction moveDirection) {
        MOVING_ENTITY.set(direction);
        entity.func_213315_a(MoverType.PISTON, new Vector3d(progress * (double)moveDirection.func_82601_c(), progress * (double)moveDirection.func_96559_d(), progress * (double)moveDirection.func_82599_e()));
        MOVING_ENTITY.set(null);
    }

    private void moveStuckEntities(float progress) {
        Direction direction;
        if (this.isHoney() && (direction = this.getMotionDirection()).func_176740_k().func_176722_c()) {
            double collisionShapeTop = this.pistonState.func_196952_d((IBlockReader)this.field_145850_b, this.field_174879_c).func_197758_c(Direction.Axis.Y);
            AxisAlignedBB axisalignedbb = this.moveByPositionAndProgress(new AxisAlignedBB(0.0, collisionShapeTop, 0.0, 1.0, 1.5000000999999998, 1.0));
            double d1 = progress - this.progress;
            for (Entity entity2 : this.field_145850_b.func_175674_a(null, axisalignedbb, entity -> ReinforcedPistonTileEntity.canPushEntity(axisalignedbb, entity))) {
                ReinforcedPistonTileEntity.pushEntity(direction, entity2, d1, direction);
            }
        }
    }

    private static boolean canPushEntity(AxisAlignedBB shape, Entity entity) {
        return entity.func_184192_z() == PushReaction.NORMAL && entity.func_233570_aj_() && entity.func_226277_ct_() >= shape.field_72340_a && entity.func_226277_ct_() <= shape.field_72336_d && entity.func_226281_cx_() >= shape.field_72339_c && entity.func_226281_cx_() <= shape.field_72334_f;
    }

    private boolean isHoney() {
        return this.pistonState.func_203425_a(Blocks.field_226907_mc_);
    }

    public Direction getMotionDirection() {
        return this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d();
    }

    private static double getMovement(AxisAlignedBB headShape, Direction direction, AxisAlignedBB facing) {
        switch (direction) {
            case EAST: {
                return headShape.field_72336_d - facing.field_72340_a;
            }
            case WEST: {
                return facing.field_72336_d - headShape.field_72340_a;
            }
            default: {
                return headShape.field_72337_e - facing.field_72338_b;
            }
            case DOWN: {
                return facing.field_72337_e - headShape.field_72338_b;
            }
            case SOUTH: {
                return headShape.field_72334_f - facing.field_72339_c;
            }
            case NORTH: 
        }
        return facing.field_72334_f - headShape.field_72339_c;
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB boundingBox) {
        double extendedProgress = this.getExtendedProgress(this.progress);
        return boundingBox.func_72317_d((double)this.field_174879_c.func_177958_n() + extendedProgress * (double)this.pistonFacing.func_82601_c(), (double)this.field_174879_c.func_177956_o() + extendedProgress * (double)this.pistonFacing.func_96559_d(), (double)this.field_174879_c.func_177952_p() + extendedProgress * (double)this.pistonFacing.func_82599_e());
    }

    private void fixEntityWithinPistonBase(Entity entity, Direction pushDirection, double progress) {
        double d1;
        Direction direction;
        double d0;
        AxisAlignedBB pistonBoundingBox;
        AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
        if (entityBoundingBox.func_72326_a(pistonBoundingBox = VoxelShapes.func_197868_b().func_197752_a().func_186670_a(this.field_174879_c)) && Math.abs((d0 = ReinforcedPistonTileEntity.getMovement(pistonBoundingBox, direction = pushDirection.func_176734_d(), entityBoundingBox) + 0.01) - (d1 = ReinforcedPistonTileEntity.getMovement(pistonBoundingBox, direction, entityBoundingBox.func_191500_a(pistonBoundingBox)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, progress) + 0.01;
            ReinforcedPistonTileEntity.pushEntity(pushDirection, entity, d0, direction);
        }
    }

    public BlockState getPistonState() {
        return this.pistonState;
    }

    public void clearPistonTileEntity() {
        if (this.field_145850_b != null && (this.lastProgress < 1.0f || this.field_145850_b.field_72995_K)) {
            this.lastProgress = this.progress = 1.0f;
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_203425_a((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                BlockState pushedState = this.shouldHeadBeRendered ? Blocks.field_150350_a.func_176223_P() : Block.func_199770_b((BlockState)this.pistonState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                if (this.tileEntityTag != null) {
                    TileEntity te;
                    TileEntity tileEntity = te = pushedState.hasTileEntity() ? pushedState.createTileEntity((IBlockReader)this.field_145850_b) : null;
                    if (te != null) {
                        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
                        te.func_230337_a_(this.pistonState, this.tileEntityTag);
                        chunk.func_177426_a(this.field_174879_c, te);
                    }
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, pushedState, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, pushedState.func_177230_c(), this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        this.lastTicked = this.field_145850_b.func_82737_E();
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            if (this.field_145850_b.field_72995_K && this.deathTicks < 5) {
                ++this.deathTicks;
            } else {
                this.field_145850_b.func_175713_t(this.field_174879_c);
                this.func_145843_s();
                if (this.pistonState != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_203425_a((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                    BlockState pushedState = Block.func_199770_b((BlockState)this.pistonState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                    if (pushedState.func_196958_f()) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, this.pistonState, 84);
                        Block.func_196263_a((BlockState)this.pistonState, (BlockState)pushedState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c, (int)3);
                    } else {
                        if (pushedState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)pushedState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                            pushedState = (BlockState)pushedState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                        }
                        if (this.tileEntityTag != null) {
                            TileEntity te;
                            TileEntity tileEntity = te = pushedState.hasTileEntity() ? pushedState.createTileEntity((IBlockReader)this.field_145850_b) : null;
                            if (te != null) {
                                Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
                                te.func_230337_a_(this.pistonState, this.tileEntityTag);
                                chunk.func_177426_a(this.field_174879_c, te);
                            }
                        }
                        this.field_145850_b.func_180501_a(this.field_174879_c, pushedState, 67);
                        this.field_145850_b.func_190524_a(this.field_174879_c, pushedState.func_177230_c(), this.field_174879_c);
                    }
                }
            }
        } else {
            float f = this.progress + 0.5f;
            this.moveCollidedEntities(f);
            this.moveStuckEntities(f);
            this.progress = f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.pistonState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("blockState"));
        this.pistonFacing = Direction.func_82600_a((int)compound.func_74762_e("facing"));
        this.lastProgress = this.progress = compound.func_74760_g("progress");
        this.extending = compound.func_74767_n("extending");
        this.shouldHeadBeRendered = compound.func_74767_n("source");
        this.tileEntityTag = compound.func_74775_l("movedTileEntityTag");
        this.owner.read(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.pistonState));
        compound.func_74768_a("facing", this.pistonFacing.func_176745_a());
        compound.func_74776_a("progress", this.lastProgress);
        compound.func_74757_a("extending", this.extending);
        compound.func_74757_a("source", this.shouldHeadBeRendered);
        compound.func_218657_a("movedTileEntityTag", (INBT)this.tileEntityTag);
        if (this.owner != null) {
            this.owner.write(compound, false);
        }
        return compound;
    }

    public VoxelShape getCollisionShape(IBlockReader world, BlockPos pos) {
        VoxelShape shape = !this.extending && this.shouldHeadBeRendered ? ((BlockState)this.pistonState.func_206870_a((Property)PistonBlock.field_176320_b, (Comparable)Boolean.valueOf(true))).func_196951_e(world, pos) : VoxelShapes.func_197880_a();
        if ((double)this.progress < 1.0 && MOVING_ENTITY.get() == this.getMotionDirection()) {
            return shape;
        }
        BlockState state = this.shouldPistonHeadBeRendered() ? (BlockState)((BlockState)((Block)SCContent.REINFORCED_PISTON_HEAD.get()).func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)this.pistonFacing)).func_206870_a((Property)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 4.0f)) : this.pistonState;
        float f = this.getExtendedProgress(this.progress);
        double d0 = (float)this.pistonFacing.func_82601_c() * f;
        double d1 = (float)this.pistonFacing.func_96559_d() * f;
        double d2 = (float)this.pistonFacing.func_82599_e() * f;
        return VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)state.func_196951_e(world, pos).func_197751_a(d0, d1, d2));
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public long getLastTicked() {
        return this.lastTicked;
    }

    public double func_145833_n() {
        return 68.0;
    }
}

