/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetinalScannerTileEntity
extends DisguisableTileEntity
implements IViewActivated,
ITickableTileEntity,
ILockable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private Option.BooleanOption activatedByEntities = new Option.BooleanOption("activatedByEntities", false);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((RetinalScannerTileEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private GameProfile ownerProfile;
    private int viewCooldown = 0;

    public RetinalScannerTileEntity() {
        super(SCContent.teTypeRetinalScanner);
    }

    public void func_73660_a() {
        this.checkView(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockRayTraceResult rayTraceResult) {
        if (!this.isLocked()) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177229_b((net.minecraft.state.Property)RetinalScannerBlock.FACING) != rayTraceResult.func_216354_b()) {
                return false;
            }
            if (!((Boolean)state.func_177229_b((net.minecraft.state.Property)RetinalScannerBlock.POWERED)).booleanValue() && !EntityUtils.isInvisible(entity)) {
                String name = entity.func_200200_C_().getString();
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == Items.field_196184_dx) {
                        name = PlayerUtils.getNameOfSkull(player);
                    }
                    if (name == null || !this.getOwner().getName().equals(name) && !ModuleUtils.isAllowed((IModuleInventory)this, name)) {
                        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), TextFormatting.RED);
                        return true;
                    }
                } else if (this.activatedOnlyByPlayer()) {
                    return false;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((net.minecraft.state.Property)RetinalScannerBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, (Block)SCContent.RETINAL_SCANNER.get());
                this.field_145850_b.func_205220_G_().func_205360_a(new BlockPos((Vector3i)this.field_174879_c), (Object)SCContent.RETINAL_SCANNER.get(), this.getSignalLength());
                if (entity instanceof PlayerEntity && ((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer((PlayerEntity)entity, (IFormattableTextComponent)Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", name), TextFormatting.GREEN);
                }
                return true;
            }
        } else if (entity instanceof PlayerEntity && ((Boolean)this.sendMessage.get()).booleanValue()) {
            TranslationTextComponent blockName = Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).func_149739_a(), new Object[0]);
            PlayerUtils.sendMessageToPlayer((PlayerEntity)entity, (IFormattableTextComponent)blockName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), TextFormatting.DARK_RED, false);
            return true;
        }
        return false;
    }

    @Override
    public int getDefaultViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength};
    }

    public static void setProfileCache(PlayerProfileCache profileCacheIn) {
        profileCache = profileCacheIn;
    }

    public static void setSessionService(MinecraftSessionService sessionServiceIn) {
        sessionService = sessionServiceIn;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!StringUtils.func_151246_b((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner")) {
            if (this.ownerProfile == null || !this.getOwner().getName().equals(this.ownerProfile.getName())) {
                this.setPlayerProfile(new GameProfile((UUID)null, this.getOwner().getName()));
            }
            this.updatePlayerProfile();
            CompoundNBT ownerProfileTag = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)ownerProfileTag, (GameProfile)this.ownerProfile);
            tag.func_218657_a("ownerProfile", (INBT)ownerProfileTag);
            return tag;
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.ownerProfile = NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("ownerProfile"));
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    public void setPlayerProfile(@Nullable GameProfile profile) {
        this.ownerProfile = profile;
    }

    public void updatePlayerProfile() {
        if (profileCache == null && ServerLifecycleHooks.getCurrentServer() != null) {
            RetinalScannerTileEntity.setProfileCache(ServerLifecycleHooks.getCurrentServer().func_152358_ax());
        }
        if (sessionService == null && ServerLifecycleHooks.getCurrentServer() != null) {
            RetinalScannerTileEntity.setSessionService(ServerLifecycleHooks.getCurrentServer().func_147130_as());
        }
        this.ownerProfile = this.updateGameProfile(this.ownerProfile);
    }

    private GameProfile updateGameProfile(GameProfile input) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    try {
                        gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("========= WARNING =========");
                        LOGGER.warn("The following error is likely caused by using an offline server. If you are not using an offline server (online-mode=true in the server.properties), please reach out to the SecurityCraft devs in their Discord #help channel: https://discord.gg/U8DvBAW");
                        LOGGER.warn("To mitigate this error, you can set the configuration option \"retinalScannerFace\" to false, in order to disable rendering the owner's face on retinal scanners.");
                        LOGGER.error("The exception's stacktrace is as follows:", (Throwable)e);
                    }
                }
                return gameprofile;
            }
            return input;
        }
        return input;
    }
}

