/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.blocks.ScannerDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SpecialDoorTileEntity;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ScannerDoorTileEntity
extends SpecialDoorTileEntity
implements IViewActivated,
ILockable {
    private int viewCooldown = 0;

    public ScannerDoorTileEntity() {
        super(SCContent.teTypeScannerDoor);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.checkView(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockRayTraceResult rayTraceResult) {
        BlockState upperState = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockState lowerState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Direction.Axis facingAxis = ScannerDoorBlock.getFacingAxis(upperState);
        if (upperState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER && !EntityUtils.isInvisible(entity)) {
            if (!(entity instanceof PlayerEntity) || facingAxis != rayTraceResult.func_216354_b().func_176740_k()) {
                return false;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (!this.isLocked()) {
                String name = entity.func_200200_C_().getString();
                if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == Items.field_196184_dx) {
                    name = PlayerUtils.getNameOfSkull(player);
                }
                if (name == null || !this.getOwner().getName().equals(name) && !ModuleUtils.isAllowed((IModuleInventory)this, name)) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), TextFormatting.RED);
                    return true;
                }
                boolean open = (Boolean)lowerState.func_177229_b((Property)DoorBlock.field_176519_b) == false;
                int length = this.getSignalLength();
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)upperState.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)upperState.func_177229_b((Property)DoorBlock.field_176519_b) == false)), 3);
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), (BlockState)lowerState.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)lowerState.func_177229_b((Property)DoorBlock.field_176519_b) == false)), 3);
                this.field_145850_b.func_217378_a(null, open ? 1005 : 1011, this.field_174879_c, 0);
                if (open && length > 0) {
                    this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)SCContent.SCANNER_DOOR.get(), length);
                }
                if (open && this.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", name), TextFormatting.GREEN);
                }
                return true;
            }
            if (this.sendsMessages()) {
                TranslationTextComponent blockName = Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).func_77658_a(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)blockName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), TextFormatting.DARK_RED, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 0;
    }
}

