/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.BulletEntity;
import net.geforcemods.securitycraft.entity.IMSBombEntity;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.network.PacketDistributor;

public class TrophySystemTileEntity
extends DisguisableTileEntity
implements ITickableTileEntity,
ILockable {
    public static final int RANGE = 10;
    public static final int RENDER_DISTANCE = 50;
    private final Map<EntityType<?>, Boolean> projectileFilter = new LinkedHashMap();
    public ProjectileEntity entityBeingTargeted = null;
    public int cooldown = this.getCooldownTime();
    private final Random random = new Random();

    public TrophySystemTileEntity() {
        super(SCContent.teTypeTrophySystem);
        this.projectileFilter.put(SCContent.eTypeBullet, true);
        this.projectileFilter.put(EntityType.field_200747_am, true);
        this.projectileFilter.put(EntityType.field_200790_d, true);
        this.projectileFilter.put(EntityType.field_200744_aj, true);
        this.projectileFilter.put(SCContent.eTypeImsBomb, true);
        this.projectileFilter.put(EntityType.field_200767_G, true);
        this.projectileFilter.put(EntityType.field_200799_m, true);
        this.projectileFilter.put(EntityType.field_200723_aB, true);
        this.projectileFilter.put(EntityType.field_200739_ae, true);
        this.projectileFilter.put(EntityType.field_200770_J, true);
        this.projectileFilter.put(EntityType.field_200751_aq, true);
        this.projectileFilter.put(EntityType.field_200752_ar, true);
        this.projectileFilter.put(EntityType.field_200746_al, true);
        this.projectileFilter.put(EntityType.field_200810_x, true);
        this.projectileFilter.put(EntityType.field_200784_X, false);
    }

    public void func_73660_a() {
        Entity shooter;
        ProjectileEntity target;
        if (!(this.field_145850_b.field_72995_K || this.entityBeingTargeted != null || (target = this.getPotentialTarget()) == null || (shooter = target.func_234616_v_()) != null && (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && PlayerUtils.areOnSameTeam(shooter.func_200200_C_().getString(), this.getOwner().getName()) || shooter.func_110124_au() != null && shooter.func_110124_au().toString().equals(this.getOwner().getUUID()) || ModuleUtils.isAllowed((IModuleInventory)this, shooter.func_200200_C_().getString())))) {
            this.setTarget(target);
        }
        if (this.entityBeingTargeted == null) {
            return;
        }
        if (!this.entityBeingTargeted.func_70089_S()) {
            this.resetTarget();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(50.0);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        CompoundNBT projectilesNBT = new CompoundNBT();
        int i = 0;
        for (boolean b : this.projectileFilter.values()) {
            projectilesNBT.func_74757_a("projectile" + i, b);
            ++i;
        }
        tag.func_218657_a("projectiles", (INBT)projectilesNBT);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("projectiles", 10)) {
            CompoundNBT projectilesNBT = tag.func_74775_l("projectiles");
            int i = 0;
            for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectilesNBT.func_74767_n("projectile" + i));
                ++i;
            }
        }
    }

    public void setTarget(ProjectileEntity target) {
        this.entityBeingTargeted = target;
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new SetTrophySystemTarget(this.field_174879_c, target.func_145782_y()));
        }
    }

    private void destroyTarget() {
        this.entityBeingTargeted.func_70106_y();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217385_a(null, this.entityBeingTargeted.func_226277_ct_(), this.entityBeingTargeted.func_226278_cu_(), this.entityBeingTargeted.func_226281_cx_(), 0.1f, Explosion.Mode.NONE);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = this.getCooldownTime();
        this.entityBeingTargeted = null;
    }

    private ProjectileEntity getPotentialTarget() {
        List<Object> potentialTargets = new ArrayList();
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(10.0, 10.0, 10.0);
        potentialTargets.addAll(this.field_145850_b.func_175647_a(ProjectileEntity.class, area, this::isAllowedToTarget));
        potentialTargets = potentialTargets.stream().filter(this::filterSCProjectiles).collect(Collectors.toList());
        if (potentialTargets.size() <= 0) {
            return null;
        }
        int target = this.random.nextInt(potentialTargets.size());
        return (ProjectileEntity)potentialTargets.get(target);
    }

    private boolean isAllowedToTarget(ProjectileEntity target) {
        if (target instanceof TridentEntity || target instanceof FishingBobberEntity || target instanceof PotionEntity || target instanceof ExperienceBottleEntity) {
            return false;
        }
        return this.projectileFilter.getOrDefault(target.func_200600_R(), this.projectileFilter.get(EntityType.field_200784_X));
    }

    private boolean filterSCProjectiles(ProjectileEntity projectile) {
        Owner owner = null;
        if (projectile instanceof BulletEntity) {
            owner = ((BulletEntity)projectile).getOwner();
        } else if (projectile instanceof IMSBombEntity) {
            owner = ((IMSBombEntity)projectile).getOwner();
        } else if (projectile.func_234616_v_() instanceof SentryEntity) {
            owner = ((SentryEntity)projectile.func_234616_v_()).getOwner();
        }
        return owner == null || !owner.owns(this) && !ModuleUtils.isAllowed((IModuleInventory)this, owner.getName());
    }

    public void toggleFilter(EntityType<?> projectileType) {
        this.setFilter(projectileType, this.projectileFilter.get(projectileType) == false);
    }

    public void setFilter(EntityType<?> projectileType, boolean allowed) {
        if (this.projectileFilter.containsKey(projectileType)) {
            this.projectileFilter.put(projectileType, allowed);
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.send(PacketDistributor.SERVER.noArg(), (Object)new SyncTrophySystem(this.field_174879_c, projectileType, allowed));
            }
        }
    }

    public boolean getFilter(EntityType<?> projectileType) {
        return this.projectileFilter.get(projectileType);
    }

    public Map<EntityType<?>, Boolean> getFilters() {
        return this.projectileFilter;
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.SMART) {
            for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectileType != EntityType.field_200784_X);
            }
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART, ModuleType.SPEED, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public int getCooldownTime() {
        return this.hasModule(ModuleType.SPEED) ? 4 : 8;
    }
}

