/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.ClearLoggerClient;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class UsernameLoggerTileEntity
extends DisguisableTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
ILockable {
    private static final int TICKS_BETWEEN_ATTACKS = 80;
    private Option.IntOption searchRadius = new Option.IntOption(() -> ((UsernameLoggerTileEntity)this).func_174877_v(), "searchRadius", 3, 1, 20, 1, true);
    public String[] players = new String[100];
    public String[] uuids = new String[100];
    public long[] timestamps = new long[100];
    private int cooldown = 80;

    public UsernameLoggerTileEntity() {
        super(SCContent.teTypeUsernameLogger);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooldown-- > 0) {
                return;
            }
            if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
                this.field_145850_b.func_175647_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g((double)((Integer)this.searchRadius.get()).intValue()), e -> !e.func_175149_v()).forEach(this::addPlayer);
                this.syncLoggedPlayersToClient();
            }
            this.cooldown = 80;
        }
    }

    public void addPlayer(PlayerEntity player) {
        String playerName = player.func_200200_C_().getString();
        long timestamp = System.currentTimeMillis();
        if (!(this.getOwner().isOwner(player) || EntityUtils.isInvisible((LivingEntity)player) || this.wasPlayerRecentlyAdded(playerName, timestamp))) {
            if (ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player)) {
                return;
            }
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] != null && !this.players[i].equals("")) continue;
                this.players[i] = player.func_200200_C_().getString();
                this.uuids[i] = player.func_146103_bH().getId().toString();
                this.timestamps[i] = timestamp;
                break;
            }
        }
    }

    private boolean wasPlayerRecentlyAdded(String username, long timestamp) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.players[i].equals(username) || this.timestamps[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.players.length; ++i) {
            tag.func_74778_a("player" + i, this.players[i] == null ? "" : this.players[i]);
            tag.func_74778_a("uuid" + i, this.uuids[i] == null ? "" : this.uuids[i]);
            tag.func_74772_a("timestamp" + i, this.timestamps[i]);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        for (int i = 0; i < this.players.length; ++i) {
            this.players[i] = tag.func_74779_i("player" + i);
            this.uuids[i] = tag.func_74779_i("uuid" + i);
            this.timestamps[i] = tag.func_74763_f("timestamp" + i);
        }
    }

    public void syncLoggedPlayersToClient() {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateLogger(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), i, this.players[i], this.uuids[i], this.timestamps[i]));
        }
    }

    public void clearLoggedPlayersOnClient() {
        SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new ClearLoggerClient(this.field_174879_c));
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new GenericTEContainer(SCContent.cTypeUsernameLogger, windowId, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius};
    }
}

