/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Utils {
    public static final Style GRAY_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
    public static final ITextComponent INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    public static String removeLastChar(String line) {
        if (line == null || line.isEmpty()) {
            return "";
        }
        return line.substring(0, line.length() - 1);
    }

    public static TranslationTextComponent getFormattedCoordinates(BlockPos pos) {
        return new TranslationTextComponent("messages.securitycraft:formattedCoordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public static void setISinTEAppropriately(World world, BlockPos pos, NonNullList<ItemStack> contents) {
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
        if (connectedScanner == null) {
            return;
        }
        connectedScanner.setContents(contents);
    }

    public static TranslationTextComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof TranslationTextComponent) {
                params[i] = Utils.localize(((TranslationTextComponent)params[i]).func_150268_i(), ((TranslationTextComponent)params[i]).func_150271_j());
                continue;
            }
            if (!(params[i] instanceof BlockPos)) continue;
            params[i] = Utils.getFormattedCoordinates((BlockPos)params[i]);
        }
        return new TranslationTextComponent(key, params);
    }
}

