/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class DoubleProperty
extends TeamProperty<Double> {
    public final double minValue;
    public final double maxValue;

    public DoubleProperty(ResourceLocation id, double def, double min, double max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public DoubleProperty(ResourceLocation id, double def) {
        this(id, def, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleProperty(ResourceLocation id, PacketBuffer buf) {
        super(id, buf.readDouble());
        this.minValue = buf.readDouble();
        this.maxValue = buf.readDouble();
    }

    @Override
    public TeamPropertyType<Double> getType() {
        return TeamPropertyType.DOUBLE;
    }

    @Override
    public Optional<Double> fromString(String string) {
        try {
            double num = Double.parseDouble(string);
            return Optional.of(MathHelper.func_151237_a((double)num, (double)this.minValue, (double)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeDouble(((Double)this.defaultValue).doubleValue());
        buf.writeDouble(this.minValue);
        buf.writeDouble(this.maxValue);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Double> value) {
        config.addDouble(this.id.func_110624_b() + "." + this.id.func_110623_a(), ((Double)value.value).doubleValue(), value.consumer, ((Double)this.defaultValue).doubleValue(), this.minValue, this.maxValue);
    }

    @Override
    public INBT toNBT(Double value) {
        return DoubleNBT.func_229684_a_((double)value);
    }

    @Override
    public Optional<Double> fromNBT(INBT tag) {
        if (tag instanceof NumberNBT) {
            return Optional.of(MathHelper.func_151237_a((double)((NumberNBT)tag).func_150286_g(), (double)this.minValue, (double)this.maxValue));
        }
        return Optional.empty();
    }
}

