/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class BlockUtils {
    @Nullable
    public static DirectionProperty getFirstDirectionProperty(BlockState state) {
        for (Property prop : state.func_235904_r_()) {
            if (!(prop instanceof DirectionProperty)) continue;
            return (DirectionProperty)prop;
        }
        return null;
    }

    @Nullable
    public static Direction getFirstPropertyFacingValue(BlockState state) {
        DirectionProperty prop = BlockUtils.getFirstDirectionProperty(state);
        return prop != null ? (Direction)state.func_177229_b((Property)prop) : null;
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state, String separator) {
        Collection properties = state.func_235904_r_();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Property prop : properties) {
                Comparable val = state.func_177229_b(prop);
                if (prop instanceof BooleanProperty) {
                    String pre = val.equals(Boolean.TRUE) ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    lines.add(prop.func_177701_a() + separator + pre + val.toString());
                    continue;
                }
                if (prop instanceof DirectionProperty) {
                    lines.add(prop.func_177701_a() + separator + GuiBase.TXT_GOLD + val.toString());
                    continue;
                }
                if (prop instanceof IntegerProperty) {
                    lines.add(prop.func_177701_a() + separator + GuiBase.TXT_AQUA + val.toString());
                    continue;
                }
                lines.add(prop.func_177701_a() + separator + val.toString());
            }
            return lines;
        }
        return Collections.emptyList();
    }
}

