/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.LeafcutterAntAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.LeafcutterAntAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityLeafcutterAnt
extends AnimalEntity
implements IAngerable,
IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)13);
    protected static final EntitySize QUEEN_SIZE = EntitySize.func_220311_c((float)1.25f, (float)0.98f);
    public static final ResourceLocation QUEEN_LOOT = new ResourceLocation("alexsmobs", "entities/leafcutter_ant_queen");
    private static final DataParameter<Optional<BlockPos>> LEAF_HARVESTED_POS = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<BlockState>> LEAF_HARVESTED_STATE = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> HAS_LEAF = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ANT_SCALE = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Direction> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> QUEEN = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(EntityLeafcutterAnt.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final RangedInteger ANGRY_TIMER = TickRangeConverter.func_233037_a_((int)10, (int)20);
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private Direction prevAttachDir = Direction.DOWN;
    @Nullable
    private EntityLeafcutterAnt caravanHead;
    @Nullable
    private EntityLeafcutterAnt caravanTail;
    private UUID lastHurtBy;
    @Nullable
    private BlockPos hivePos = null;
    private int stayOutOfHiveCountdown;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isUpsideDownNavigator;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AMItemRegistry.GONGYLIDIA});
    private int haveBabyCooldown = 0;

    public EntityLeafcutterAnt(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.switchNavigator(true);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn instanceof PlayerEntity && ((PlayerEntity)entitylivingbaseIn).func_184812_l_()) {
            return;
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isQueen() ? QUEEN_LOOT : super.func_184647_J();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    private void switchNavigator(boolean rightsideUp) {
        if (rightsideUp) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new ClimberPathNavigator((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = false;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 0.6f, false);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = true;
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    private static boolean isSideSolid(IBlockReader reader, BlockPos pos, Entity entityIn, Direction direction) {
        return Block.func_208061_a((VoxelShape)reader.func_180495_p(pos).func_215685_b(reader, pos, ISelectionContext.func_216374_a((Entity)entityIn)), (Direction)direction);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ReturnToHiveGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new TameableAITempt(this, 1.1, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeafcutterAntAIFollowCaravan(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LeafcutterAntAIForageLeaves(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 30, 1.0, 25, 7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AngerGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isQueen() && !this.func_70631_g_() ? QUEEN_SIZE : super.func_213305_a(poseIn);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isQueen() ? AMSoundRegistry.LEAFCUTTER_ANT_QUEEN_HURT : AMSoundRegistry.LEAFCUTTER_ANT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return this.isQueen() ? AMSoundRegistry.LEAFCUTTER_ANT_QUEEN_HURT : AMSoundRegistry.LEAFCUTTER_ANT_HURT;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
    }

    private void pacifyAllNearby() {
        this.func_241356_K__();
        List list = this.field_70170_p.func_217357_a(EntityLeafcutterAnt.class, this.func_174813_aQ().func_72314_b(20.0, 6.0, 20.0));
        for (EntityLeafcutterAnt ant : list) {
            ant.func_241356_K__();
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (type != ActionResultType.SUCCESS && item == AMItemRegistry.GONGYLIDIA) {
            if (this.isQueen() && this.haveBabyCooldown == 0) {
                int babies = 1 + this.field_70146_Z.nextInt(1);
                this.pacifyAllNearby();
                for (int i = 0; i < babies; ++i) {
                    EntityLeafcutterAnt leafcutterAnt = (EntityLeafcutterAnt)AMEntityRegistry.LEAFCUTTER_ANT.func_200721_a(this.field_70170_p);
                    leafcutterAnt.func_82149_j((Entity)this);
                    leafcutterAnt.func_70873_a(-24000);
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                    this.field_70170_p.func_217376_c((Entity)leafcutterAnt);
                }
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.haveBabyCooldown = 24000;
                this.func_82227_f(false);
            } else {
                this.pacifyAllNearby();
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)48);
                this.func_70691_i(3.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 48) {
            for (int i = 0; i < 3; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        boolean flag;
        this.prevAttachChangeProgress = this.attachChangeProgress;
        super.func_70071_h_();
        if (this.isQueen() && this.func_213311_cf() < EntityLeafcutterAnt.QUEEN_SIZE.field_220315_a) {
            this.func_213323_x_();
        }
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.25f;
        }
        this.field_70138_W = this.isQueen() ? 1.0f : 0.5f;
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70170_p.field_72995_K && !this.isQueen()) {
            this.setBesideClimbableBlock(this.field_70123_F || this.field_70124_G && !this.func_233570_aj_());
            if (this.func_233570_aj_() || this.func_203005_aq() || this.func_180799_ab()) {
                this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.DOWN);
            } else if (this.field_70124_G) {
                this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.UP);
            } else {
                flag = false;
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction dir : HORIZONTALS) {
                    BlockPos antPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_()));
                    BlockPos offsetPos = antPos.func_177972_a(dir);
                    Vector3d offset = Vector3d.func_237489_a_((Vector3i)offsetPos);
                    if (!(closestDistance > this.func_213303_ch().func_72438_d(offset)) || !this.field_70170_p.func_234929_a_(offsetPos, (Entity)this, dir.func_176734_d())) continue;
                    closestDistance = this.func_213303_ch().func_72438_d(offset);
                    closestDirection = dir;
                }
                this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)closestDirection);
            }
        }
        flag = false;
        if (this.getAttachmentFacing() != Direction.DOWN) {
            if (this.getAttachmentFacing() == Direction.UP) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
            } else {
                if (!this.field_70123_F && this.getAttachmentFacing() != Direction.UP) {
                    Vector3d vec = Vector3d.func_237491_b_((Vector3i)this.getAttachmentFacing().func_176730_m());
                    this.func_213317_d(this.func_213322_ci().func_178787_e(vec.func_72432_b().func_216372_d((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
                    flag = true;
                }
            }
        }
        if (this.getAttachmentFacing() == Direction.UP) {
            this.func_189654_d(true);
            this.func_213317_d(vector3d.func_216372_d(0.7, 1.0, 0.7));
        } else {
            this.func_189654_d(false);
        }
        if (!flag && this.func_70617_f_()) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.4, 1.0));
        }
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = this.getAttachmentFacing();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity attackTarget;
            if (this.getAttachmentFacing() == Direction.UP && !this.isUpsideDownNavigator) {
                this.switchNavigator(false);
            }
            if (this.getAttachmentFacing() != Direction.UP && this.isUpsideDownNavigator) {
                this.switchNavigator(true);
            }
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.field_70173_aa % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
            if ((attackTarget = this.func_70638_az()) != null && this.func_70032_d((Entity)attackTarget) < attackTarget.func_213311_cf() + this.func_213311_cf() + 1.0f && this.func_70685_l((Entity)attackTarget) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 6) {
                float damage = (int)this.func_233637_b_(Attributes.field_233823_f_);
                attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private boolean isClimeableFromSide(BlockPos offsetPos, Direction opposite) {
        return false;
    }

    private boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.hivePos);
        return tileentity instanceof TileEntityLeafcutterAnthill;
    }

    protected void func_191955_a(BlockState state) {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGRY_TIMER.func_233018_a_(this.field_70146_Z));
    }

    protected void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, false);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(LEAF_HARVESTED_POS, Optional.empty());
        this.field_70180_af.func_187214_a(LEAF_HARVESTED_STATE, Optional.empty());
        this.field_70180_af.func_187214_a(HAS_LEAF, (Object)false);
        this.field_70180_af.func_187214_a(QUEEN, (Object)false);
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(ANT_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setAntScale(0.75f + this.field_70146_Z.nextFloat() * 0.3f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public float getAntScale() {
        return ((Float)this.field_70180_af.func_187225_a(ANT_SCALE)).floatValue();
    }

    public void setAntScale(float scale) {
        this.field_70180_af.func_187227_b(ANT_SCALE, (Object)Float.valueOf(scale));
    }

    public BlockPos getHarvestedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(LEAF_HARVESTED_POS)).orElse(null);
    }

    public void setLeafHarvestedPos(BlockPos harvestedPos) {
        this.field_70180_af.func_187227_b(LEAF_HARVESTED_POS, Optional.ofNullable(harvestedPos));
    }

    public BlockState getHarvestedState() {
        return ((Optional)this.field_70180_af.func_187225_a(LEAF_HARVESTED_STATE)).orElse(null);
    }

    public void setLeafHarvestedState(BlockState state) {
        this.field_70180_af.func_187227_b(LEAF_HARVESTED_STATE, Optional.ofNullable(state));
    }

    public boolean hasLeaf() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_LEAF);
    }

    public void setLeaf(boolean leaf) {
        this.field_70180_af.func_187227_b(HAS_LEAF, (Object)leaf);
    }

    public boolean isQueen() {
        return (Boolean)this.field_70180_af.func_187225_a(QUEEN);
    }

    public void setQueen(boolean queen) {
        boolean prev = this.isQueen();
        if (!prev && queen) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(36.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
            this.func_70606_j(36.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(2.0);
        }
        this.field_70180_af.func_187227_b(QUEEN, (Object)queen);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.setLeaf(compound.func_74767_n("Leaf"));
        this.setQueen(compound.func_74767_n("Queen"));
        this.setAntScale(compound.func_74760_g("AntScale"));
        BlockState blockstate = null;
        if (compound.func_150297_b("HarvestedLeafState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("HarvestedLeafState"))).func_196958_f()) {
            blockstate = null;
        }
        this.stayOutOfHiveCountdown = compound.func_74762_e("CannotEnterHiveTicks");
        this.haveBabyCooldown = compound.func_74762_e("BabyCooldown");
        this.hivePos = null;
        if (compound.func_74764_b("HivePos")) {
            this.hivePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HivePos"));
        }
        this.setLeafHarvestedState(blockstate);
        if (compound.func_74764_b("HLPX")) {
            int i = compound.func_74762_e("HLPX");
            int j = compound.func_74762_e("HLPY");
            int k = compound.func_74762_e("HLPZ");
            this.field_70180_af.func_187227_b(LEAF_HARVESTED_POS, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(LEAF_HARVESTED_POS, Optional.empty());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("AttachFace", (byte)((Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        compound.func_74757_a("Leaf", this.hasLeaf());
        compound.func_74757_a("Queen", this.isQueen());
        compound.func_74776_a("AntScale", this.getAntScale());
        BlockState blockstate = this.getHarvestedState();
        if (blockstate != null) {
            compound.func_218657_a("HarvestedLeafState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
        if (this.hasHive()) {
            compound.func_218657_a("HivePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getHivePos()));
        }
        compound.func_74768_a("CannotEnterHiveTicks", this.stayOutOfHiveCountdown);
        compound.func_74768_a("BabyCooldown", this.haveBabyCooldown);
        BlockPos blockpos = this.getHarvestedPos();
        if (blockpos != null) {
            compound.func_74768_a("HLPX", blockpos.func_177958_n());
            compound.func_74768_a("HLPY", blockpos.func_177956_o());
            compound.func_74768_a("HLPZ", blockpos.func_177952_p());
        }
    }

    public void setStayOutOfHiveCountdown(int p_226450_1_) {
        this.stayOutOfHiveCountdown = p_226450_1_;
    }

    private boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.hivePos);
        return tileentity instanceof TileEntityLeafcutterAnthill && ((TileEntityLeafcutterAnthill)tileentity).isNearFire();
    }

    private boolean doesHiveHaveSpace(BlockPos pos) {
        TileEntity tileentity = this.field_70170_p.func_175625_s(pos);
        if (tileentity instanceof TileEntityLeafcutterAnthill) {
            return !((TileEntityLeafcutterAnthill)tileentity).isFullOfAnts();
        }
        return false;
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    @Nullable
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityLeafcutterAnt caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityLeafcutterAnt getCaravanHead() {
        return this.caravanHead;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    public boolean shouldLeadCaravan() {
        return !this.hasLeaf();
    }

    public void func_233629_a_(LivingEntity p_233629_1_, boolean p_233629_2_) {
        double d2;
        double d1;
        p_233629_1_.field_184618_aE = p_233629_1_.field_70721_aZ;
        double d0 = p_233629_1_.func_226277_ct_() - p_233629_1_.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = (p_233629_1_.func_226278_cu_() - p_233629_1_.field_70167_r) * 2.0) * d1 + (d2 = p_233629_1_.func_226281_cx_() - p_233629_1_.field_70166_s) * d2)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        p_233629_1_.field_70721_aZ += (f - p_233629_1_.field_70721_aZ) * 0.4f;
        p_233629_1_.field_184619_aG += p_233629_1_.field_70721_aZ;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.setAnimation(ANIMATION_BITE);
        return true;
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(EntityLeafcutterAnt beeIn) {
            super((CreatureEntity)beeIn, new Class[0]);
            this.func_220794_a(new Class[]{EntityLeafcutterAnt.class});
        }

        public boolean func_75253_b() {
            return EntityLeafcutterAnt.this.func_233678_J__() && super.func_75253_b();
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityLeafcutterAnt && this.field_75299_d.func_70685_l((Entity)targetIn)) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }

    private class ReturnToHiveGoal
    extends Goal {
        private int searchCooldown = 1;
        private BlockPos hivePos;
        private int approachTime = 0;

        public boolean func_75250_a() {
            if (EntityLeafcutterAnt.this.stayOutOfHiveCountdown > 0) {
                return false;
            }
            if (EntityLeafcutterAnt.this.hasLeaf() || EntityLeafcutterAnt.this.isQueen()) {
                --this.searchCooldown;
                BlockPos hive = EntityLeafcutterAnt.this.hivePos;
                if (hive != null && EntityLeafcutterAnt.this.field_70170_p.func_175625_s(hive) instanceof TileEntityLeafcutterAnthill) {
                    this.hivePos = hive;
                    return true;
                }
                if (this.searchCooldown <= 0) {
                    this.searchCooldown = 400;
                    PointOfInterestManager pointofinterestmanager = ((ServerWorld)EntityLeafcutterAnt.this.field_70170_p).func_217443_B();
                    Stream stream = pointofinterestmanager.func_225399_a(AMPointOfInterestRegistry.LEAFCUTTER_ANT_HILL.func_221045_c(), (Predicate)Predicates.alwaysTrue(), EntityLeafcutterAnt.this.func_233580_cy_(), 100, PointOfInterestManager.Status.ANY);
                    List listOfHives = stream.collect(Collectors.toList());
                    BlockPos ret = null;
                    for (BlockPos pos : listOfHives) {
                        if (ret != null && !(pos.func_177951_i((Vector3i)EntityLeafcutterAnt.this.func_233580_cy_()) < ret.func_177951_i((Vector3i)EntityLeafcutterAnt.this.func_233580_cy_()))) continue;
                        ret = pos;
                    }
                    this.hivePos = ret;
                    EntityLeafcutterAnt.this.hivePos = ret;
                    return this.hivePos != null;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.hivePos != null && EntityLeafcutterAnt.this.func_195048_a(Vector3d.func_237490_a_((Vector3i)this.hivePos, (double)1.0)) > 1.0;
        }

        public void func_75251_c() {
            this.hivePos = null;
            this.searchCooldown = 20;
            this.approachTime = 0;
        }

        public void func_75246_d() {
            TileEntity tileentity;
            double dist = EntityLeafcutterAnt.this.func_195048_a(Vector3d.func_237490_a_((Vector3i)this.hivePos, (double)1.0));
            if (dist < (double)1.2f && EntityLeafcutterAnt.this.func_226270_aj_().equals((Object)this.hivePos) && (tileentity = EntityLeafcutterAnt.this.field_70170_p.func_175625_s(this.hivePos)) instanceof TileEntityLeafcutterAnthill) {
                TileEntityLeafcutterAnthill beehivetileentity = (TileEntityLeafcutterAnthill)tileentity;
                beehivetileentity.tryEnterHive(EntityLeafcutterAnt.this, EntityLeafcutterAnt.this.hasLeaf());
            }
            if (dist < 16.0) {
                ++this.approachTime;
                int n = this.approachTime < 200 ? 2 : 10;
                if (dist < (double)n && EntityLeafcutterAnt.this.func_226278_cu_() >= (double)this.hivePos.func_177956_o()) {
                    if (EntityLeafcutterAnt.this.getAttachmentFacing() != Direction.DOWN) {
                        EntityLeafcutterAnt.this.func_213317_d(EntityLeafcutterAnt.this.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                    }
                    EntityLeafcutterAnt.this.func_70605_aq().func_75642_a((double)this.hivePos.func_177958_n() + 0.5, (double)this.hivePos.func_177956_o() + 1.5, (double)this.hivePos.func_177952_p() + 0.5, 1.0);
                }
                EntityLeafcutterAnt.this.field_70699_by.func_226336_g_();
                EntityLeafcutterAnt.this.field_70699_by.func_75492_a((double)this.hivePos.func_177958_n() + 0.5, (double)this.hivePos.func_177956_o() + (double)1.6f, (double)this.hivePos.func_177952_p() + 0.5, 1.0);
            } else {
                this.startMovingToFar(this.hivePos);
            }
        }

        private boolean startMovingToFar(BlockPos pos) {
            EntityLeafcutterAnt.this.field_70699_by.func_226335_a_(10.0f);
            EntityLeafcutterAnt.this.field_70699_by.func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
            return EntityLeafcutterAnt.this.field_70699_by.func_75505_d() != null && EntityLeafcutterAnt.this.field_70699_by.func_75505_d().func_224771_h();
        }
    }
}

