/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Optional;
import java.util.UUID;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.chiseling.ChiselingContext;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;

public class ChiselingManager
implements IChiselingManager {
    private static final ChiselingManager INSTANCE = new ChiselingManager();
    private UUID activeInstanceId = UUID.randomUUID();
    private final ThreadLocal<UUID> activeThreadId = ThreadLocal.withInitial(() -> this.activeInstanceId);
    private final ThreadLocal<Table<UUID, ResourceLocation, IChiselingContext>> contexts = ThreadLocal.withInitial(HashBasedTable::create);
    private final ThreadLocal<Table<UUID, ResourceLocation, Long>> lastUsedChiselMoments = ThreadLocal.withInitial(HashBasedTable::create);

    private ChiselingManager() {
    }

    public static ChiselingManager getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<IChiselingContext> get(PlayerEntity playerEntity, IChiselMode mode) {
        UUID playerId = playerEntity.func_110124_au();
        ResourceLocation worldId = playerEntity.func_130014_f_().func_234923_W_().func_240901_a_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        return Optional.of(currentStored);
    }

    @Override
    public Optional<IChiselingContext> get(PlayerEntity playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus) {
        UUID playerId = playerEntity.func_110124_au();
        ResourceLocation worldId = playerEntity.func_130014_f_().func_234923_W_().func_240901_a_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        if (currentStored.getModeOfOperandus() == modeOfOperandus) {
            return Optional.of(currentStored);
        }
        return Optional.empty();
    }

    @Override
    public IChiselingContext create(PlayerEntity playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus, boolean simulation, ItemStack causingItemStack) {
        UUID playerId = playerEntity.func_110124_au();
        ResourceLocation worldId = playerEntity.func_130014_f_().func_234923_W_().func_240901_a_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored != null && !simulation) {
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }
        ChiselingContext newContext = new ChiselingContext((IWorld)playerEntity.func_130014_f_(), mode, modeOfOperandus, simulation, () -> {
            if (simulation) {
                return;
            }
            this.lastUsedChiselMoments.get().put((Object)playerId, (Object)worldId, (Object)playerEntity.field_70173_aa);
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }, causingItemStack, playerEntity);
        if (!simulation) {
            this.contexts.get().put((Object)playerId, (Object)worldId, (Object)newContext);
        }
        return newContext;
    }

    public boolean canChisel(PlayerEntity playerEntity) {
        this.validateOrSetup();
        UUID playerId = playerEntity.func_110124_au();
        ResourceLocation worldId = playerEntity.func_130014_f_().func_234923_W_().func_240901_a_();
        Long lastChiselTime = (Long)this.lastUsedChiselMoments.get().get((Object)playerId, (Object)worldId);
        if (lastChiselTime == null) {
            return true;
        }
        long time = playerEntity.field_70173_aa;
        long diffSinceLastUse = time - lastChiselTime;
        if (diffSinceLastUse > 3L) {
            this.lastUsedChiselMoments.get().remove((Object)playerId, (Object)worldId);
            return true;
        }
        return false;
    }

    public void onServerStarting() {
        this.activeInstanceId = UUID.randomUUID();
    }

    private void validateOrSetup() {
        UUID threadId = this.activeThreadId.get();
        if (threadId != this.activeInstanceId) {
            this.contexts.get().clear();
            this.lastUsedChiselMoments.get().clear();
            this.activeThreadId.set(this.activeInstanceId);
        }
    }

    public void resetLastChiselCountdown(PlayerEntity player) {
        this.lastUsedChiselMoments.get().row((Object)player.func_110124_au()).clear();
    }
}

