/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.cubed;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class CubedChiselMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final int bitsPerSide;
    private final boolean aligned;
    private final IFormattableTextComponent displayName;
    private final IFormattableTextComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    CubedChiselMode(int bitsPerSide, boolean aligned, IFormattableTextComponent displayName, IFormattableTextComponent multiLineDisplayName, ResourceLocation iconName) {
        this.bitsPerSide = bitsPerSide;
        this.aligned = aligned;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                mutator.inWorldMutableStream().forEach(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), facingVector -> this.aligned ? facingVector : facingVector.func_216372_d(1.0, -1.0, 1.0));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.func_184812_l_()) {
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).forEach(state -> state.overrideState(heldBlockState));
                }
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context, Function<Direction, Vector3d> placementFacingAdapter, Function<Vector3d, Vector3d> fullFacingVectorAdapter) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vector3d alignmentOffset = Vector3d.field_186680_a;
        Vector3d fullFacingVector = fullFacingVectorAdapter.apply(this.aligned ? new Vector3d(1.0, 1.0, 1.0) : Vector3d.func_237491_b_((Vector3i)RayTracingUtils.getFullFacingVector(playerEntity)));
        if (this.aligned) {
            Vector3d inBlockOffset = hitVector.func_178788_d(Vector3d.func_237491_b_((Vector3i)new BlockPos(hitVector)));
            BlockPos bitsInBlockOffset = new BlockPos(inBlockOffset.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
            BlockPos targetedSectionIndices = new BlockPos(bitsInBlockOffset.func_177958_n() / this.bitsPerSide, bitsInBlockOffset.func_177956_o() / this.bitsPerSide, bitsInBlockOffset.func_177952_p() / this.bitsPerSide);
            BlockPos targetedStartPoint = new BlockPos(targetedSectionIndices.func_177958_n() * this.bitsPerSide, targetedSectionIndices.func_177956_o() * this.bitsPerSide, targetedSectionIndices.func_177952_p() * this.bitsPerSide);
            BlockPos targetedBitsInBlockOffset = bitsInBlockOffset.func_177973_b((Vector3i)targetedStartPoint);
            alignmentOffset = Vector3d.func_237491_b_((Vector3i)targetedBitsInBlockOffset).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }
        Vector3d finalAlignmentOffset = alignmentOffset.func_216369_h(fullFacingVector);
        BlockPosStreamProvider.getForRange(this.bitsPerSide).forEach(bitPos -> context.include(hitVector.func_178788_d(finalAlignmentOffset).func_178787_e(Vector3d.func_237491_b_((Vector3i)bitPos).func_216369_h(fullFacingVector).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()))));
        return Optional.empty();
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ITextComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(this.aligned ? ModChiselModeGroups.CUBED_ALIGNED : ModChiselModeGroups.CUBED);
    }
}

