/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withhighlight.IWithHighlightItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    private ItemStackUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ItemStackUtils. This is a utility class");
    }

    public static ItemStack getItemStackFromBlockState(@NotNull BlockState blockState) {
        if (blockState.func_177230_c() instanceof IFluidBlock) {
            return FluidUtil.getFilledBucket((FluidStack)new FluidStack(((IFluidBlock)blockState.func_177230_c()).getFluid(), 1000));
        }
        Item item = ItemStackUtils.getItem(blockState);
        if (item != Items.field_190931_a && item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
    }

    public static Item getItem(@NotNull BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block.equals(Blocks.field_150353_l)) {
            return Items.field_151129_at;
        }
        if (block instanceof CropsBlock) {
            ItemStack stack = ((CropsBlock)block).func_185473_a((IBlockReader)new SingleBlockBlockReader(blockState), BlockPos.field_177992_a, blockState);
            if (!stack.func_190926_b()) {
                return stack.func_77973_b();
            }
            return Items.field_151014_N;
        }
        if (block instanceof FarmlandBlock || block instanceof GrassPathBlock) {
            return Blocks.field_150346_d.func_199767_j();
        }
        if (block instanceof FireBlock) {
            return Items.field_151033_d;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.field_222087_nH;
        }
        if (block == Blocks.field_222404_kP) {
            return Items.field_222068_kQ;
        }
        return block.func_199767_j();
    }

    public static ItemStack getModeItemStackFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IWithModeItem) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IWithModeItem) {
            return playerEntity.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getHighlightItemStackFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IWithHighlightItem) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IWithHighlightItem) {
            return playerEntity.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getMultiStateItemStackFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IMultiStateItem) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IMultiStateItem) {
            return playerEntity.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPatternItemStackFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IPatternItem) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IPatternItem) {
            return playerEntity.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static Hand getPatternHandFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return Hand.MAIN_HAND;
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IPatternItem) {
            return Hand.OFF_HAND;
        }
        return Hand.MAIN_HAND;
    }

    public static ItemStack getBitItemStackFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IBitItem) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IBitItem) {
            return playerEntity.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public static BlockState getHeldBitBlockStateFromPlayer(@Nullable PlayerEntity playerEntity) {
        if (playerEntity == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof IBitItem) {
            return ((IBitItem)playerEntity.func_184614_ca().func_77973_b()).getBitState(playerEntity.func_184614_ca());
        }
        if (playerEntity.func_184592_cb().func_77973_b() instanceof IBitItem) {
            return ((IBitItem)playerEntity.func_184592_cb().func_77973_b()).getBitState(playerEntity.func_184592_cb());
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static BlockState getStateFromItem(ItemStack is) {
        try {
            if (!is.func_190926_b() && is.func_77973_b() instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)is.func_77973_b();
                return blockItem.func_179223_d().func_176223_P();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

