/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IntIdentityHashBiMap;

public class LitematicaBlockStatePaletteHashMap
implements ILitematicaBlockStatePalette {
    private final IntIdentityHashBiMap<BlockState> statePaletteMap;
    private final ILitematicaBlockStatePaletteResizer paletteResizer;
    private final int bits;

    public LitematicaBlockStatePaletteHashMap(int bitsIn, ILitematicaBlockStatePaletteResizer paletteResizer) {
        this.bits = bitsIn;
        this.paletteResizer = paletteResizer;
        this.statePaletteMap = new IntIdentityHashBiMap(1 << bitsIn);
    }

    @Override
    public int idFor(BlockState state) {
        int i = this.statePaletteMap.func_148757_b((Object)state);
        if (i == -1 && (i = this.statePaletteMap.func_186808_c((Object)state)) >= 1 << this.bits) {
            i = this.paletteResizer.onResize(this.bits + 1, state);
        }
        return i;
    }

    @Override
    @Nullable
    public BlockState getBlockState(int indexKey) {
        return (BlockState)this.statePaletteMap.func_148745_a(indexKey);
    }

    @Override
    public int getPaletteSize() {
        return this.statePaletteMap.func_186810_b();
    }

    private void requestNewId(BlockState state) {
        int newId;
        int origId = this.statePaletteMap.func_186808_c((Object)state);
        if (origId >= 1 << this.bits && (newId = this.paletteResizer.onResize(this.bits + 1, LitematicaBlockStateContainer.AIR_BLOCK_STATE)) <= origId) {
            this.statePaletteMap.func_186808_c((Object)state);
        }
    }

    @Override
    public void readFromNBT(ListNBT tagList) {
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            this.requestNewId(state);
        }
    }

    @Override
    public ListNBT writeToNBT() {
        ListNBT tagList = new ListNBT();
        for (int id = 0; id < this.statePaletteMap.func_186810_b(); ++id) {
            BlockState state = (BlockState)this.statePaletteMap.func_148745_a(id);
            if (state == null) {
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            CompoundNBT tag = NBTUtil.func_190009_a((BlockState)state);
            tagList.add((Object)tag);
        }
        return tagList;
    }

    @Override
    public boolean setMapping(List<BlockState> list) {
        this.statePaletteMap.func_186812_a();
        for (BlockState blockState : list) {
            this.statePaletteMap.func_186808_c((Object)blockState);
        }
        return true;
    }
}

