/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class CrusherRecipe
extends MultiblockRecipe {
    public static IRecipeType<CrusherRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<CrusherRecipe>> SERIALIZER;
    public final Ingredient input;
    public final ItemStack output;
    public final List<StackWithChance> secondaryOutputs = new ArrayList<StackWithChance>();
    public static Map<ResourceLocation, CrusherRecipe> recipeList;

    public CrusherRecipe(ResourceLocation id, ItemStack output, Ingredient input, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.setTimeAndEnergy(50, energy);
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.output});
    }

    @Override
    protected IERecipeSerializer<CrusherRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.output);
        for (StackWithChance output : this.secondaryOutputs) {
            if (output.getStack().func_190926_b() || !(ApiUtils.RANDOM.nextFloat() < output.getChance())) continue;
            list.add((Object)output.getStack());
        }
        return list;
    }

    public CrusherRecipe addToSecondaryOutput(StackWithChance output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryOutputs.add(output);
        return this;
    }

    public static CrusherRecipe findRecipe(ItemStack input) {
        for (CrusherRecipe recipe : recipeList.values()) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 4;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

