/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.network.PacketDistributor;

public class BucketWheelTileEntity
extends MultiblockPartTileEntity<BucketWheelTileEntity>
implements IEBlockInterfaces.IBlockBounds {
    public float rotation = 0.0f;
    public final NonNullList<ItemStack> digStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public boolean active = false;
    public ItemStack particleStack = ItemStack.field_190927_a;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    private static CachedShapesWithTransform<BlockPos, Direction> SHAPES = CachedShapesWithTransform.createDirectional(BucketWheelTileEntity::getBoxes);

    public BucketWheelTileEntity() {
        super(IEMultiblocks.BUCKET_WHEEL, (TileEntityType)IETileTypes.BUCKET_WHEEL.get(), false);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        float nbtRot = nbt.func_74760_g("rotation");
        this.rotation = (double)Math.abs(nbtRot - this.rotation) > 5.0 * (Double)IEServerConfig.MACHINES.excavator_speed.get() ? nbtRot : this.rotation;
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.digStacks);
        this.active = nbt.func_74767_n("active");
        this.particleStack = nbt.func_150297_b("particleStack", 10) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("particleStack")) : ItemStack.field_190927_a;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("rotation", this.rotation);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.digStacks);
        nbt.func_74757_a("active", this.active);
        if (!this.particleStack.func_190926_b()) {
            nbt.func_218657_a("particleStack", (INBT)this.particleStack.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.formed || !new BlockPos(3, 3, 0).equals((Object)this.posInMultiblock)) {
            return;
        }
        if (this.active) {
            this.rotation = (float)((double)this.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get());
            this.rotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.particleStack.func_190926_b()) {
                ImmersiveEngineering.proxy.spawnBucketWheelFX(this, this.particleStack);
                this.particleStack = ItemStack.field_190927_a;
            }
        } else if (this.active && this.field_145850_b.func_82737_E() % 20L == 0L) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("rotation", this.rotation);
            MessageTileSync sync = new MessageTileSync(this, nbt);
            ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(CompoundNBT message) {
        NonNullList<ItemStack> nonNullList = this.digStacks;
        synchronized (nonNullList) {
            int packetRotation;
            if (message.func_150297_b("fill", 3)) {
                this.digStacks.set(message.func_74762_e("fill"), (Object)ItemStack.func_199557_a((CompoundNBT)message.func_74775_l("fillStack")));
            }
            if (message.func_150297_b("empty", 3)) {
                int toRemove = message.func_74762_e("empty");
                this.particleStack = (ItemStack)this.digStacks.get(toRemove);
                this.digStacks.set(toRemove, (Object)ItemStack.field_190927_a);
            }
            if (message.func_150297_b("rotation", 3) && (double)Math.abs((float)(packetRotation = message.func_74762_e("rotation")) - this.rotation) > 5.0 * (Double)IEServerConfig.MACHINES.excavator_speed.get()) {
                this.rotation = packetRotation;
            }
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-(this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 0), -3, -(this.getFacing().func_176740_k() == Direction.Axis.X ? 3 : 0)), this.func_174877_v().func_177982_a(this.getFacing().func_176740_k() == Direction.Axis.Z ? 4 : 1, 4, this.getFacing().func_176740_k() == Direction.Axis.X ? 4 : 1));
        }
        return this.renderAABB;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return SHAPES.get(this.posInMultiblock, this.getFacing());
    }

    private static List<AxisAlignedBB> getBoxes(BlockPos posInMultiblock) {
        AxisAlignedBB ret = ImmutableSet.of((Object)new BlockPos(3, 0, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(4, 1, 0)).contains((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(3, 6, 0), (Object)new BlockPos(2, 5, 0), (Object)new BlockPos(4, 5, 0)).contains((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0) : (new BlockPos(0, 3, 0).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0) : (new BlockPos(6, 3, 0).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(1, 2, 0), (Object)new BlockPos(1, 4, 0)).contains((Object)posInMultiblock) ? new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0) : (ImmutableSet.of((Object)new BlockPos(5, 2, 0), (Object)new BlockPos(5, 4, 0)).contains((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))))));
        return ImmutableList.of((Object)ret);
    }

    public void adjustStructureFacingAndMirrored(Direction targetFacing, boolean targetMirrored) {
        if (this == this.master() && targetFacing.func_176740_k() != Direction.Axis.Y && (this.getFacing() != targetFacing || this.getIsMirrored() != targetMirrored)) {
            boolean changePos = this.getFacing() != targetFacing ^ (this.getIsMirrored() ^ targetMirrored);
            for (int h = -3; h <= 3; ++h) {
                for (int w = -3; w <= 3; ++w) {
                    TileEntity te;
                    if (Math.abs(h) == 3 && w != 0 || Math.abs(w) == 3 && h != 0 || !((te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, h, 0).func_177967_a(this.getFacing(), w))) instanceof BucketWheelTileEntity)) continue;
                    BucketWheelTileEntity bucketTE = (BucketWheelTileEntity)te;
                    bucketTE.setFacing(targetFacing);
                    bucketTE.setMirrored(targetMirrored);
                    if (changePos) {
                        bucketTE.posInMultiblock = new BlockPos(6 - bucketTE.posInMultiblock.func_177958_n(), bucketTE.posInMultiblock.func_177956_o(), bucketTE.posInMultiblock.func_177952_p());
                    }
                    te.func_70296_d();
                    bucketTE.markContainingBlockForUpdate(null);
                    this.field_145850_b.func_175641_c(te.func_174877_v(), te.func_195044_w().func_177230_c(), 255, 0);
                }
            }
        }
    }
}

