/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ExcavatorTileEntity
extends PoweredMultiblockTileEntity<ExcavatorTileEntity, MultiblockRecipe>
implements IEBlockInterfaces.IBlockBounds {
    private static final BlockPos wheelCenterOffset = new BlockPos(1, 1, 1);
    public boolean active = false;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(ExcavatorTileEntity::getShape);
    private CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntityAt(this, () -> new DirectionalBlockPos(this.func_174877_v().func_177967_a(this.getFacing(), -1), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);

    public ExcavatorTileEntity() {
        super(IEMultiblocks.EXCAVATOR, 64000, true, (TileEntityType)IETileTypes.EXCAVATOR.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    public BlockPos getWheelCenterPos() {
        return this.getBlockPosForPos(wheelCenterOffset);
    }

    @Override
    protected int getComparatorValueOnMaster() {
        BlockPos wheelPos = this.getWheelCenterPos();
        if (SafeChunkUtils.getSafeTE((IWorld)this.field_145850_b, wheelPos) instanceof BucketWheelTileEntity) {
            MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.field_145850_b, wheelPos);
            if (info == null) {
                return 0;
            }
            if (ExcavatorHandler.mineralVeinYield == 0) {
                return 15;
            }
            long totalDepletion = 0L;
            List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
            if (veins.isEmpty()) {
                return 0;
            }
            for (Pair<MineralVein, Integer> pair : veins) {
                totalDepletion += (long)((MineralVein)pair.getLeft()).getDepletion();
            }
            float remain = (float)((long)ExcavatorHandler.mineralVeinYield - (totalDepletion /= (long)veins.size())) / (float)ExcavatorHandler.mineralVeinYield;
            return MathHelper.func_76141_d((float)(Math.max(remain, 0.0f) * 15.0f));
        }
        return 0;
    }

    @Override
    public void func_73660_a() {
        TileEntity center;
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        BlockPos wheelPos = this.getBlockPosForPos(wheelCenterOffset);
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.isAreaLoaded(wheelPos, 5) && (center = this.field_145850_b.func_175625_s(wheelPos)) instanceof BucketWheelTileEntity) {
            BucketWheelTileEntity wheel = (BucketWheelTileEntity)center;
            if (wheel != wheel.master()) {
                return;
            }
            float rot = 0.0f;
            int target = -1;
            Direction fRot = this.getFacing().func_176735_f();
            boolean mirrored = this.getIsMirrored();
            if (wheel.getFacing() == fRot && wheel.getIsMirrored() == mirrored) {
                if (this.active != wheel.active) {
                    this.field_145850_b.func_175641_c(wheel.func_174877_v(), wheel.func_195044_w().func_177230_c(), 0, this.active ? 1 : 0);
                }
                if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                    target = Math.round(rot / 360.0f * 8.0f) % 8;
                }
            } else {
                wheel.adjustStructureFacingAndMirrored(fRot, mirrored);
            }
            if (!this.isRSDisabled()) {
                MineralVein mineralVein = ExcavatorHandler.getRandomMineral(this.field_145850_b, wheelPos);
                MineralMix mineral = mineralVein != null ? mineralVein.getMineral() : null;
                int consumed = (Integer)IEServerConfig.MACHINES.excavator_consumption.get();
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    if (target >= 0) {
                        int targetDown = (target + 4) % 8;
                        CompoundNBT packet = new CompoundNBT();
                        if (((ItemStack)wheel.digStacks.get(targetDown)).func_190926_b()) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            if (!blocking.func_190926_b()) {
                                wheel.digStacks.set(targetDown, (Object)blocking);
                                wheel.func_70296_d();
                                this.markContainingBlockForUpdate(null);
                            } else if (mineral != null) {
                                this.fillBucket(mineralVein, mineral, wheelPos, wheel, targetDown);
                                mineralVein.deplete();
                            }
                            if (!((ItemStack)wheel.digStacks.get(targetDown)).func_190926_b()) {
                                packet.func_74768_a("fill", targetDown);
                                packet.func_218657_a("fillStack", (INBT)((ItemStack)wheel.digStacks.get(targetDown)).func_77955_b(new CompoundNBT()));
                            }
                        }
                        if (!((ItemStack)wheel.digStacks.get(target)).func_190926_b()) {
                            this.doProcessOutput(((ItemStack)wheel.digStacks.get(target)).func_77946_l());
                            Block b = Block.func_149634_a((Item)((ItemStack)wheel.digStacks.get(target)).func_77973_b());
                            if (b != Blocks.field_150350_a) {
                                wheel.particleStack = ((ItemStack)wheel.digStacks.get(target)).func_77946_l();
                            }
                            wheel.digStacks.set(target, (Object)ItemStack.field_190927_a);
                            wheel.func_70296_d();
                            this.markContainingBlockForUpdate(null);
                            packet.func_74768_a("empty", target);
                        }
                        if (!packet.isEmpty()) {
                            packet.func_74768_a("rotation", (int)wheel.rotation);
                            ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new MessageTileSync(wheel, packet));
                        }
                    }
                } else if (this.active) {
                    this.active = false;
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }

    ItemStack digBlocksInTheWay(BucketWheelTileEntity wheel) {
        BlockPos pos = wheel.func_174877_v().func_177982_a(0, -4, 0);
        ItemStack s = this.digBlock(pos);
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), -1));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), -2));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), 1));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), 2));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), -1).func_177972_a(this.getFacing().func_176746_e()));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), -1).func_177972_a(this.getFacing().func_176735_f()));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177972_a(this.getFacing().func_176746_e()));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177972_a(this.getFacing().func_176735_f()));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), 1).func_177972_a(this.getFacing().func_176746_e()));
        if (!s.func_190926_b()) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.getFacing(), 1).func_177972_a(this.getFacing().func_176735_f()));
        if (!s.func_190926_b()) {
            return s;
        }
        return ItemStack.field_190927_a;
    }

    ItemStack digBlock(BlockPos pos) {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return ItemStack.field_190927_a;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer(this.field_145850_b);
        BlockState blockstate = this.field_145850_b.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (!this.field_145850_b.func_175623_d(pos) && blockstate.func_185887_b((IBlockReader)this.field_145850_b, pos) != -1.0f) {
            if (!block.canHarvestBlock(blockstate, (IBlockReader)this.field_145850_b, pos, (PlayerEntity)fakePlayer)) {
                return ItemStack.field_190927_a;
            }
            block.func_176208_a(this.field_145850_b, pos, blockstate, (PlayerEntity)fakePlayer);
            if (block.removedByPlayer(blockstate, this.field_145850_b, pos, (PlayerEntity)fakePlayer, true, blockstate.func_204520_s())) {
                block.func_176206_d((IWorld)this.field_145850_b, pos, blockstate);
                ItemStack tool = new ItemStack((IItemProvider)Items.field_151035_b);
                tool.func_77966_a(Enchantments.field_185306_r, 1);
                LootContext.Builder dropContext = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216021_b(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216021_b(LootParameters.field_216289_i, (Object)tool);
                List itemsNullable = blockstate.func_215693_a(dropContext);
                NonNullList items = NonNullList.func_191196_a();
                items.addAll((Collection)itemsNullable);
                for (int i = 0; i < items.size(); ++i) {
                    if (i == 0) continue;
                    ItemEntity ei = new ItemEntity(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ((ItemStack)items.get(i)).func_77946_l());
                    this.field_145850_b.func_217376_c((Entity)ei);
                }
                this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockstate));
                if (items.size() > 0) {
                    return (ItemStack)items.get(0);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private void fillBucket(MineralVein mineralVein, MineralMix mineralMix, BlockPos wheelPos, BucketWheelTileEntity wheel, int targetDown) {
        if (mineralVein.isDepleted()) {
            return;
        }
        ItemStack ore = mineralMix.getRandomOre(Utils.RAND);
        if (ore.func_190926_b()) {
            return;
        }
        if (Utils.RAND.nextFloat() < mineralMix.failChance) {
            return;
        }
        if ((double)Utils.RAND.nextFloat() < mineralVein.getFailChance(wheelPos)) {
            return;
        }
        wheel.digStacks.set(targetDown, (Object)ore);
        wheel.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.func_177958_n() == 2 && posInMultiblock.func_177952_p() == 4) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), (Object)new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75));
        }
        if (posInMultiblock.func_177952_p() < 3 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177958_n() == 0) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0)});
            if (posInMultiblock.func_177952_p() == 2) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5));
            } else if (posInMultiblock.func_177952_p() == 1) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0));
            } else {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0));
            }
            return list;
        }
        if (new BlockPos(2, 2, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.5), (Object)new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 0.375));
        }
        if (new BlockPos(2, 2, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 0.625), (Object)new AxisAlignedBB(0.875, 0.0, 0.625, 1.0, 1.0, 1.0));
        }
        AxisAlignedBB ret = new BlockPos(0, 2, 2).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5) : (new BlockPos(0, 2, 1).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0) : (new BlockPos(0, 2, 0).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0) : (new BlockPos(2, 2, 2).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.5) : (new BlockPos(2, 2, 1).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0) : (new BlockPos(2, 2, 0).equals((Object)posInMultiblock) ? new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 0.625) : (posInMultiblock.func_177958_n() == 2 && posInMultiblock.func_177952_p() == 4 ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0) : (posInMultiblock.func_177952_p() < 3 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177958_n() == 0 ? new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0) : (posInMultiblock.func_177952_p() < 3 && posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177958_n() == 2 ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)))))))));
        return ImmutableList.of((Object)ret);
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(2, 1, 4), (Object)new BlockPos(2, 2, 4));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 5));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, this.func_174877_v().func_177967_a(this.getFacing(), -1), output, this.getFacing());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    public void disassemble() {
        super.disassemble();
        BlockPos wheelPos = this.getBlockPosForPos(wheelCenterOffset);
        TileEntity center = this.field_145850_b.func_175625_s(wheelPos);
        if (center instanceof BucketWheelTileEntity) {
            this.field_145850_b.func_175641_c(center.func_174877_v(), center.func_195044_w().func_177230_c(), 0, 0);
        }
    }
}

