/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ObjectArguments
implements IArguments {
    private static final IArguments EMPTY = new ObjectArguments(new Object[0]);
    private boolean released = false;
    private final List<Object> args;

    @Deprecated
    public ObjectArguments(IArguments arguments) {
        throw new IllegalStateException();
    }

    public ObjectArguments(Object ... args) {
        this.args = Arrays.asList(args);
    }

    public ObjectArguments(List<Object> args) {
        this.args = Objects.requireNonNull(args);
    }

    @Override
    public int count() {
        return this.args.size();
    }

    @Override
    public IArguments drop(int count) {
        if (count < 0) {
            throw new IllegalStateException("count cannot be negative");
        }
        if (count == 0) {
            return this;
        }
        if (count >= this.args.size()) {
            return EMPTY;
        }
        return new ObjectArguments(this.args.subList(count, this.args.size()));
    }

    @Override
    @Nullable
    public Object get(int index) {
        return index >= this.args.size() ? null : this.args.get(index);
    }

    @Override
    public Object[] getAll() {
        return this.args.toArray();
    }

    @Override
    @Nonnull
    public LuaTable<?, ?> getTableUnsafe(int index) throws LuaException {
        if (this.released) {
            throw new IllegalStateException("Cannot use getTableUnsafe after IArguments has been released");
        }
        return IArguments.super.getTableUnsafe(index);
    }

    @Override
    @Nonnull
    public Optional<LuaTable<?, ?>> optTableUnsafe(int index) throws LuaException {
        if (this.released) {
            throw new IllegalStateException("Cannot use optTableUnsafe after IArguments has been released");
        }
        return IArguments.super.optTableUnsafe(index);
    }

    @Override
    public void releaseImmediate() {
        this.released = true;
    }
}

