/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.api;

import dev.itsmeow.betteranimalsplus.common.entity.projectile.EntityModEgg;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;

public class ModEventBus {

    public static abstract class BAPEvent {
        private boolean canceled = false;

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public boolean isCancelled() {
            return this.canceled;
        }
    }

    public static class ShouldEggSpawnEntitiesEvent
    extends BAPEvent {
        protected static Set<Consumer<ShouldEggSpawnEntitiesEvent>> SUBSCRIBERS = new HashSet<Consumer<ShouldEggSpawnEntitiesEvent>>();
        private final EntityModEgg entity;
        private boolean shouldSpawnEntities;

        public static boolean subscribe(Consumer<ShouldEggSpawnEntitiesEvent> listener) {
            return SUBSCRIBERS.add(listener);
        }

        public static boolean unsubscribe(Consumer<ShouldEggSpawnEntitiesEvent> listener) {
            return SUBSCRIBERS.remove(listener);
        }

        public static boolean emit(EntityModEgg entity, boolean shouldSpawnEntities) {
            ShouldEggSpawnEntitiesEvent event = new ShouldEggSpawnEntitiesEvent(entity, shouldSpawnEntities);
            SUBSCRIBERS.forEach(c -> c.accept(event));
            return event.isCancelled() ? false : event.shouldSpawnEntities();
        }

        private ShouldEggSpawnEntitiesEvent(EntityModEgg entity, boolean shouldSpawnEntities) {
            this.entity = entity;
            this.shouldSpawnEntities = shouldSpawnEntities;
        }

        public EntityModEgg getEntity() {
            return this.entity;
        }

        public void setShouldSpawnEntities(boolean shouldSpawnEntities) {
            this.shouldSpawnEntities = shouldSpawnEntities;
        }

        public boolean shouldSpawnEntities() {
            return this.shouldSpawnEntities;
        }
    }

    public static class EggThrowSpawnCountEvent
    extends BAPEvent {
        protected static Set<Consumer<EggThrowSpawnCountEvent>> SUBSCRIBERS = new HashSet<Consumer<EggThrowSpawnCountEvent>>();
        private final EntityModEgg entity;
        private int spawnCount;

        public static boolean subscribe(Consumer<EggThrowSpawnCountEvent> listener) {
            return SUBSCRIBERS.add(listener);
        }

        public static boolean unsubscribe(Consumer<EggThrowSpawnCountEvent> listener) {
            return SUBSCRIBERS.remove(listener);
        }

        public static int emit(EntityModEgg entity, int spawnCount) {
            EggThrowSpawnCountEvent event = new EggThrowSpawnCountEvent(entity, spawnCount);
            SUBSCRIBERS.forEach(c -> c.accept(event));
            return event.isCancelled() ? 0 : event.getSpawnCount();
        }

        private EggThrowSpawnCountEvent(EntityModEgg entity, int spawnCount) {
            this.entity = entity;
            this.spawnCount = spawnCount;
        }

        public EntityModEgg getEntity() {
            return this.entity;
        }

        public void setSpawnCount(int spawnCount) {
            this.spawnCount = spawnCount;
        }

        public int getSpawnCount() {
            return this.spawnCount;
        }
    }

    public static class LayEggTickEvent
    extends BAPEvent {
        protected static Set<Consumer<LayEggTickEvent>> SUBSCRIBERS = new HashSet<Consumer<LayEggTickEvent>>();
        private final LivingEntity entity;

        public static boolean subscribe(Consumer<LayEggTickEvent> listener) {
            return SUBSCRIBERS.add(listener);
        }

        public static boolean unsubscribe(Consumer<LayEggTickEvent> listener) {
            return SUBSCRIBERS.remove(listener);
        }

        public static boolean emit(LivingEntity entity) {
            LayEggTickEvent event = new LayEggTickEvent(entity);
            SUBSCRIBERS.forEach(c -> c.accept(event));
            return !event.isCancelled();
        }

        private LayEggTickEvent(LivingEntity entity) {
            this.entity = entity;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }
    }
}

