/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockTurkey
extends Block
implements IWaterLoggable {
    public static final IntegerProperty BITES = IntegerProperty.func_177719_a((String)"bites", (int)0, (int)7);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape[] X_SHAPES = new VoxelShape[]{VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.4375, (double)0.8125), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.4375, (double)0.8125), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.4375, (double)0.8125), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.4375, (double)0.75), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.4375, (double)0.75), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.3125, (double)0.75), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.1875, (double)0.75), VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.125, (double)0.75)};
    protected static final VoxelShape[] Y_SHAPES = new VoxelShape[]{VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.125, (double)0.8125, (double)0.4375, (double)0.875), VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.125, (double)0.8125, (double)0.4375, (double)0.875), VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.125, (double)0.8125, (double)0.4375, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.8125, (double)0.4375, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.4375, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.3125, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.1875, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.125, (double)0.875)};

    public BlockTurkey() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151583_m));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? X_SHAPES[(Integer)state.func_177229_b((Property)BITES)] : Y_SHAPES[(Integer)state.func_177229_b((Property)BITES)];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND) {
            if (!worldIn.field_72995_K) {
                return this.eat(worldIn, pos, state, player);
            }
            ItemStack itemstack = player.func_184586_b(hand);
            return itemstack.func_190926_b() ? ActionResultType.FAIL : this.eat(worldIn, pos, state, player);
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType eat(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.FAIL;
        }
        int i = (Integer)state.func_177229_b((Property)BITES);
        if (i < 7) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            if (i < 2) {
                player.func_71024_bL().func_75122_a(2, 0.3f);
            } else {
                player.func_71024_bL().func_75122_a(4, 0.3f);
            }
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            player.func_71024_bL().func_75122_a(4, 0.3f);
        }
        return ActionResultType.CONSUME;
    }

    public void func_220082_b(BlockState state1, World level, BlockPos pos, BlockState state2, boolean unknown) {
        if (!level.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)level, pos, Direction.UP)) {
            level.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld level, BlockPos blockPos, BlockPos blockPos2) {
        if (!level.func_180495_p(blockPos.func_177977_b()).func_224755_d((IBlockReader)level, blockPos.func_177977_b(), Direction.UP)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(blockState, direction, blockState2, level, blockPos, blockPos2);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BITES, FACING, BlockStateProperties.field_208198_y});
    }
}

