/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityFeralWolf;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNonTamedTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableBetterAnimalsPlus;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCoyote
extends EntityTameableBetterAnimalsPlus
implements IDropHead<EntityTameableBetterAnimalsPlus>,
IHaveHunger<EntityTameableBetterAnimalsPlus> {
    public static final String HOSTILE_DAYTIME_KEY = "hostile_during_daytime";
    public static boolean client_hostile_override = false;
    public static final double TAMED_HEALTH = 30.0;
    public static final double UNTAMED_HEALTH = 10.0;
    protected static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityFeralWolf.class, (IDataSerializer)DataSerializers.field_187193_c);
    private int hunger;

    public EntityCoyote(EntityType<? extends EntityCoyote> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, e -> e.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AnimalEntity, EntityCoyote>(this, AnimalEntity.class, false, e -> e instanceof SheepEntity || e instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<VillagerEntity, EntityCoyote>(this, VillagerEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AbstractIllagerEntity, EntityCoyote>(this, AbstractIllagerEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<ChickenEntity, EntityCoyote>(this, ChickenEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(5, new HungerNearestAttackableTargetGoal<AbstractSkeletonEntity, EntityCoyote>(this, AbstractSkeletonEntity.class, false));
    }

    public boolean isDaytime() {
        long time = this.field_70170_p.func_72820_D() % 24000L;
        return time < 13000L || time > 23000L;
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (!this.isDaytime() || this.isHostileDaytime()) {
            super.func_70624_b(entitylivingbaseIn);
        } else if (!this.func_70909_n()) {
            super.func_70624_b(null);
        } else {
            super.func_70624_b(entitylivingbaseIn);
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            super.func_70624_b(null);
        }
    }

    protected SoundEvent func_184639_G() {
        if (!(this.isDaytime() && !this.isHostileDaytime() || this.func_70909_n())) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && (double)((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 15.0 ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        if (this.func_70638_az() != null) {
            return SoundEvents.field_187861_gG;
        }
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            Food food;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_219971_r() && (food = itemstack.func_77973_b().func_219967_s()).func_221467_c() && (double)((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 30.0) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(food.func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(!this.func_152114_e((LivingEntity)player) || this.field_70170_p.field_72995_K || this.func_70877_b(itemstack) || itemstack.func_77973_b().func_219971_r() && itemstack.func_77973_b().func_219967_s().func_221467_c())) {
                this.func_233687_w_(!this.func_233684_eK_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.isTamingItem(itemstack.func_77973_b())) {
            if (this.isHostileDaytime()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.betteranimalsplus.coyote.message.always_hostile"), Util.field_240973_b_);
                }
            } else {
                if (this.isDaytime()) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70146_Z.nextInt(100) <= 14 && !ModPlatformEvents.tame(this, player)) {
                            this.func_193101_c(player);
                            this.field_70699_by.func_75499_g();
                            this.func_70624_b(null);
                            this.func_233687_w_(true);
                            this.func_70606_j(30.0f);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.betteranimalsplus.coyote.message.currently_hostile"), Util.field_240973_b_);
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public EntityTypeContainerBAPTameable<? extends EntityCoyote> getContainer() {
        return ModEntities.COYOTE;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity || target instanceof GhastEntity || !this.func_70909_n() && this.isDaytime() && !this.isHostileDaytime())) {
            EntityCoyote coyote;
            if (target instanceof EntityCoyote && (coyote = (EntityCoyote)target).func_70909_n() && coyote.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return false;
    }

    public boolean isHostileDaytime() {
        return this.field_70170_p.func_201670_d() ? client_hostile_override : this.getContainer().getCustomConfiguration().getBoolean(HOSTILE_DAYTIME_KEY);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntityCoyote coyote = (EntityCoyote)this.getContainer().getEntityType().func_200721_a((World)world);
        if (this.func_70909_n()) {
            coyote.func_70903_f(true);
            coyote.func_184754_b(this.func_184753_b());
        }
        return coyote;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeHunger(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readHunger(compound);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_180429_a(BlockPos pos, BlockState blockStateIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0) {
            this.incrementHunger();
        }
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.func_233684_eK_()) {
            this.func_233687_w_(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(30.0);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
        }
    }

    public boolean func_213743_em() {
        return this.func_70909_n() && super.func_213743_em();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (!this.func_70909_n()) {
            return -0.15f;
        }
        return this.func_70909_n() ? 0.25f - (this.func_110138_aP() - ((Float)this.func_184212_Q().func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.04f : -0.85f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.ANTLER.get();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }
}

