/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.forge;

import dev.itsmeow.betteranimalsplus.common.CommonEventHandler;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class CommonEventHandlerImpl {
    public static void registerPlatformEvents() {
        MinecraftForge.EVENT_BUS.addListener(CommonEventHandlerImpl::lootLoad);
        MinecraftForge.EVENT_BUS.addListener(CommonEventHandlerImpl::livingDrops);
    }

    public static void lootLoad(LootTableLoadEvent event) {
        for (ResourceLocation rl : CommonEventHandler.LOOT_TABLE_INJECTIONS.keys()) {
            if (!event.getName().equals((Object)rl)) continue;
            for (ResourceLocation ref : CommonEventHandler.LOOT_TABLE_INJECTIONS.get((Object)rl)) {
                event.getTable().addPool(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ref)).func_216044_b());
            }
        }
    }

    public static void livingDrops(LivingDropsEvent event) {
        CommonEventHandler.modifyDropsList(event.getDrops(), event.getSource(), event.getEntityLiving());
    }

    public static void setSquirrelKills(PlayerEntity player, int kills) {
        CompoundNBT pTag = player.getPersistentData();
        if (!pTag.func_150297_b("betteranimalsplus", 10)) {
            pTag.func_218657_a("betteranimalsplus", (INBT)new CompoundNBT());
        }
        CompoundNBT bTag = pTag.func_74775_l("betteranimalsplus");
        bTag.func_74768_a("squirrel_kills", kills);
    }

    public static void setSquirrelKills(PlayerEntity player, Function<Integer, Integer> mutator) {
        CompoundNBT bTag;
        CompoundNBT pTag = player.getPersistentData();
        if (!pTag.func_150297_b("betteranimalsplus", 10)) {
            pTag.func_218657_a("betteranimalsplus", (INBT)new CompoundNBT());
        }
        bTag.func_74768_a("squirrel_kills", mutator.apply((bTag = pTag.func_74775_l("betteranimalsplus")).func_150297_b("squirrel_kills", 3) ? bTag.func_74762_e("squirrel_kills") : 0).intValue());
    }

    public static int getSquirrelKills(PlayerEntity player) {
        if (player.getPersistentData().func_150297_b("betteranimalsplus", 10) && player.getPersistentData().func_74775_l("betteranimalsplus").func_150297_b("squirrel_kills", 3)) {
            return player.getPersistentData().func_74775_l("betteranimalsplus").func_74762_e("squirrel_kills");
        }
        return 0;
    }
}

