/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.event.forge;

import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.RecipeUpdateEvent;
import me.shedaniel.architectury.event.events.TextureStitchEvent;
import me.shedaniel.architectury.event.events.TooltipEvent;
import me.shedaniel.architectury.event.events.client.ClientChatEvent;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.impl.TooltipEventColorContextImpl;
import me.shedaniel.architectury.impl.TooltipEventPositionContextImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerImplClient {
    private static final ThreadLocal<TooltipEventColorContextImpl> tooltipColorContext = ThreadLocal.withInitial(TooltipEventColorContextImpl::new);
    private static final ThreadLocal<TooltipEventPositionContextImpl> tooltipPositionContext = ThreadLocal.withInitial(TooltipEventPositionContextImpl::new);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemTooltipEvent event) {
        TooltipEvent.ITEM.invoker().append(event.getItemStack(), event.getToolTip(), event.getFlags());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTickEvent.CLIENT_PRE.invoker().tick(Minecraft.func_71410_x());
        } else if (event.phase == TickEvent.Phase.END) {
            ClientTickEvent.CLIENT_POST.invoker().tick(Minecraft.func_71410_x());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            GuiEvent.RENDER_HUD.invoker().renderHud(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ClientPlayerNetworkEvent.LoggedInEvent event) {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.invoker().join(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.invoker().quit(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ClientPlayerNetworkEvent.RespawnEvent event) {
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.invoker().respawn(event.getOldPlayer(), event.getNewPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (GuiEvent.INIT_PRE.invoker().init(event.getGui(), ScreenHooks.getButtons(event.getGui()), event.getGui().func_231039_at__()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiEvent.INIT_POST.invoker().init(event.getGui(), ScreenHooks.getButtons(event.getGui()), event.getGui().func_231039_at__());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            GuiEvent.DEBUG_TEXT_LEFT.invoker().gatherText(event.getLeft());
            GuiEvent.DEBUG_TEXT_RIGHT.invoker().gatherText(event.getRight());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(net.minecraftforge.client.event.ClientChatEvent event) {
        ActionResult<String> process = ClientChatEvent.CLIENT.invoker().process(event.getMessage());
        if (process.func_188398_b() != null) {
            event.setMessage((String)process.func_188398_b());
        }
        if (process.func_188397_a() == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ClientChatReceivedEvent event) {
        ActionResult<ITextComponent> process = ClientChatEvent.CLIENT_RECEIVED.invoker().process(event.getType(), event.getMessage(), event.getSenderUUID());
        if (process.func_188398_b() != null) {
            event.setMessage((ITextComponent)process.func_188398_b());
        }
        if (process.func_188397_a() == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            ClientWorld world = (ClientWorld)event.getWorld();
            ClientLifecycleEvent.CLIENT_WORLD_LOAD.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiOpenEvent event) {
        ActionResult<Screen> result = GuiEvent.SET_SCREEN.invoker().modifyScreen(event.getGui());
        switch (result.func_188397_a()) {
            case FAIL: {
                event.setCanceled(true);
                return;
            }
            case SUCCESS: {
                event.setGui((Screen)result.func_188398_b());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (GuiEvent.RENDER_PRE.invoker().render(event.getGui(), event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiEvent.RENDER_POST.invoker().render(event.getGui(), event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickEmpty event) {
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.invoker().click(event.getPlayer(), event.getHand());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.LeftClickEmpty event) {
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.invoker().click(event.getPlayer(), event.getHand());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RecipesUpdatedEvent event) {
        RecipeUpdateEvent.EVENT.invoker().update(event.getRecipeManager());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RenderTooltipEvent.Pre event) {
        if (TooltipEvent.RENDER_FORGE_PRE.invoker().renderTooltip(event.getMatrixStack(), event.getLines(), event.getX(), event.getY()) == ActionResultType.FAIL) {
            event.setCanceled(true);
            return;
        }
        TooltipEventPositionContextImpl positionContext = tooltipPositionContext.get();
        positionContext.reset(event.getX(), event.getY());
        TooltipEvent.RENDER_MODIFY_POSITION.invoker().renderTooltip(event.getMatrixStack(), positionContext);
        event.setX(positionContext.getTooltipX());
        event.setY(positionContext.getTooltipY());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RenderTooltipEvent.Color event) {
        TooltipEventColorContextImpl colorContext = tooltipColorContext.get();
        colorContext.reset();
        colorContext.setBackgroundColor(event.getBackground());
        colorContext.setOutlineGradientTopColor(event.getBorderStart());
        colorContext.setOutlineGradientBottomColor(event.getBorderEnd());
        TooltipEvent.RENDER_MODIFY_COLOR.invoker().renderTooltip(event.getMatrixStack(), event.getX(), event.getY(), colorContext);
        event.setBackground(colorContext.getBackgroundColor());
        event.setBorderEnd(colorContext.getOutlineGradientBottomColor());
        event.setBorderStart(colorContext.getOutlineGradientTopColor());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseScrollEvent.Pre event) {
        if (ClientScreenInputEvent.MOUSE_SCROLLED_PRE.invoker().mouseScrolled(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getScrollDelta()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseScrollEvent.Post event) {
        ClientScreenInputEvent.MOUSE_SCROLLED_POST.invoker().mouseScrolled(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getScrollDelta());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (ClientScreenInputEvent.MOUSE_CLICKED_PRE.invoker().mouseClicked(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getButton()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseClickedEvent.Post event) {
        ClientScreenInputEvent.MOUSE_CLICKED_POST.invoker().mouseClicked(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getButton());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseDragEvent.Pre event) {
        if (ClientScreenInputEvent.MOUSE_DRAGGED_PRE.invoker().mouseDragged(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseDragEvent.Post event) {
        ClientScreenInputEvent.MOUSE_DRAGGED_POST.invoker().mouseDragged(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        if (ClientScreenInputEvent.MOUSE_RELEASED_PRE.invoker().mouseReleased(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getButton()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.MouseReleasedEvent.Post event) {
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.invoker().mouseReleased(Minecraft.func_71410_x(), event.getGui(), event.getMouseX(), event.getMouseY(), event.getButton());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (ClientScreenInputEvent.CHAR_TYPED_PRE.invoker().charTyped(Minecraft.func_71410_x(), event.getGui(), event.getCodePoint(), event.getModifiers()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardCharTypedEvent.Post event) {
        ClientScreenInputEvent.CHAR_TYPED_POST.invoker().charTyped(Minecraft.func_71410_x(), event.getGui(), event.getCodePoint(), event.getModifiers());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (ClientScreenInputEvent.KEY_PRESSED_PRE.invoker().keyPressed(Minecraft.func_71410_x(), event.getGui(), event.getKeyCode(), event.getScanCode(), event.getModifiers()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        ClientScreenInputEvent.KEY_PRESSED_POST.invoker().keyPressed(Minecraft.func_71410_x(), event.getGui(), event.getKeyCode(), event.getScanCode(), event.getModifiers());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event) {
        if (ClientScreenInputEvent.KEY_RELEASED_PRE.invoker().keyReleased(Minecraft.func_71410_x(), event.getGui(), event.getKeyCode(), event.getScanCode(), event.getModifiers()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(GuiScreenEvent.KeyboardKeyReleasedEvent.Post event) {
        ClientScreenInputEvent.KEY_RELEASED_POST.invoker().keyReleased(Minecraft.func_71410_x(), event.getGui(), event.getKeyCode(), event.getScanCode(), event.getModifiers());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(InputEvent.MouseScrollEvent event) {
        if (ClientRawInputEvent.MOUSE_SCROLLED.invoker().mouseScrolled(Minecraft.func_71410_x(), event.getScrollDelta()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(InputEvent.RawMouseEvent event) {
        if (ClientRawInputEvent.MOUSE_CLICKED_PRE.invoker().mouseClicked(Minecraft.func_71410_x(), event.getButton(), event.getAction(), event.getMods()) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(InputEvent.MouseInputEvent event) {
        ClientRawInputEvent.MOUSE_CLICKED_POST.invoker().mouseClicked(Minecraft.func_71410_x(), event.getButton(), event.getAction(), event.getMods());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(InputEvent.KeyInputEvent event) {
        ClientRawInputEvent.KEY_PRESSED.invoker().keyPressed(Minecraft.func_71410_x(), event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModBasedEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(TextureStitchEvent.Pre event) {
            TextureStitchEvent.PRE.invoker().stitch(event.getMap(), arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(TextureStitchEvent.Post event) {
            TextureStitchEvent.POST.invoker().stitch(event.getMap());
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(FMLClientSetupEvent event) {
            ClientLifecycleEvent.CLIENT_SETUP.invoker().stateChanged((Minecraft)event.getMinecraftSupplier().get());
        }
    }
}

