/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity.collision;

import com.github.alexthe666.citadel.server.entity.collision.CustomCollisionsNodeProcessor;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CustomCollisionsNavigator
extends GroundPathNavigator {
    public CustomCollisionsNavigator(MobEntity mob, World world) {
        super(mob, world);
    }

    protected PathFinder func_179679_a(int i) {
        this.field_179695_a = new CustomCollisionsNodeProcessor();
        return new PathFinder(this.field_179695_a, i);
    }

    protected boolean func_75493_a(Vector3d posVec31, Vector3d posVec32, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.func_76128_c((double)posVec31.field_72450_a);
        int j = MathHelper.func_76128_c((double)posVec31.field_72449_c);
        double d0 = posVec32.field_72450_a - posVec31.field_72450_a;
        double d1 = posVec32.field_72449_c - posVec31.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(i, MathHelper.func_76128_c((double)posVec31.field_72448_b), j, sizeX += 2, sizeY, sizeZ += 2, posVec31, d0 *= d3, d1 *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)i - posVec31.field_72450_a;
        double d7 = (double)j - posVec31.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int k = d0 < 0.0 ? -1 : 1;
        int l = d1 < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)posVec32.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)posVec32.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, MathHelper.func_76128_c((double)posVec31.field_72448_b), j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - p_179692_7_.field_72450_a;
            if ((d0 * p_179692_8_ + (d1 = (double)blockpos.func_177952_p() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ < 0.0 || this.field_75513_b.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_75513_b, blockpos, PathType.LAND)) && !((ICustomCollisions)this.field_75515_a).canPassThrough(blockpos, this.field_75513_b.func_180495_p(blockpos), null)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d vec31, double p_179683_8_, double p_179683_10_) {
        int i = x - sizeX / 2;
        int j = z - sizeZ / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - vec31.field_72450_a;
                double d1 = (double)l + 0.5 - vec31.field_72449_c;
                if (d0 * p_179683_8_ + d1 * p_179683_10_ < 0.0) continue;
                PathNodeType pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y - 1, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                mutable.func_181079_c(k, y - 1, l);
                if (!this.func_230287_a_(pathnodetype) || ((ICustomCollisions)this.field_75515_a).canPassThrough((BlockPos)mutable, this.field_75513_b.func_180495_p((BlockPos)mutable), null)) {
                    return false;
                }
                pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(pathnodetype);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean func_230287_a_(PathNodeType p_230287_1_) {
        if (p_230287_1_ == PathNodeType.WATER) {
            return false;
        }
        if (p_230287_1_ == PathNodeType.LAVA) {
            return false;
        }
        return p_230287_1_ != PathNodeType.OPEN;
    }
}

