/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageStarting
implements Message<MessageStarting> {
    private boolean start;
    private boolean playSound;
    private UUID uuid;

    public MessageStarting() {
    }

    public MessageStarting(boolean start, boolean playSound, PlayerEntity player) {
        this.start = start;
        this.playSound = playSound;
        this.uuid = player.func_110124_au();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        if (!context.getSender().func_110124_au().equals(this.uuid)) {
            Main.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity riding = context.getSender().func_184187_bx();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (context.getSender().equals((Object)car.getDriver())) {
            car.setStarting(this.start, this.playSound);
        }
    }

    @Override
    public MessageStarting fromBytes(PacketBuffer buf) {
        this.start = buf.readBoolean();
        this.playSound = buf.readBoolean();
        this.uuid = buf.func_179253_g();
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.start);
        buf.writeBoolean(this.playSound);
        buf.func_179252_a(this.uuid);
    }
}

