/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipe
extends IPMultiblockRecipe {
    public static final IRecipeType<DistillationRecipe> TYPE = IRecipeType.func_222147_a((String)"immersivepetroleum:distillationtower");
    public static Map<ResourceLocation, DistillationRecipe> recipes = new HashMap<ResourceLocation, DistillationRecipe>();
    protected final FluidTagInput input;
    protected final FluidStack[] fluidOutput;
    protected final ItemStack[] itemOutput;
    protected final double[] chances;

    public static DistillationRecipe findRecipe(FluidStack input) {
        if (!recipes.isEmpty()) {
            for (DistillationRecipe r : recipes.values()) {
                if (r.input == null || !r.input.testIgnoringAmount(input)) continue;
                return r;
            }
        }
        return null;
    }

    public static DistillationRecipe loadFromNBT(CompoundNBT nbt) {
        FluidStack input = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("input"));
        return DistillationRecipe.findRecipe(input);
    }

    public DistillationRecipe(ResourceLocation id, FluidStack[] fluidOutput, ItemStack[] itemOutput, FluidTagInput input, int energy, int time, double[] chances) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.chances = chances;
        this.input = input;
        this.fluidInputList = Collections.singletonList(input);
        this.fluidOutputList = Arrays.asList(this.fluidOutput);
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])itemOutput);
        this.timeAndEnergy(time, energy);
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.distillationTower_timeModifier.get(), () -> IPServerConfig.REFINING.distillationTower_energyModifier.get());
    }

    protected IERecipeSerializer<DistillationRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList output = NonNullList.func_191196_a();
        for (int i = 0; i < this.itemOutput.length; ++i) {
            if (!((double)tile.func_145831_w().field_73012_v.nextFloat() <= this.chances[i])) continue;
            output.add((Object)this.itemOutput[i]);
        }
        return output;
    }

    public FluidTagInput getInputFluid() {
        return this.input;
    }

    public double[] chances() {
        return this.chances;
    }
}

