/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DistillationTowerTileEntity
extends PoweredMultiblockTileEntity<DistillationTowerTileEntity, DistillationRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int INV_0 = 0;
    public static final int INV_1 = 1;
    public static final int INV_2 = 2;
    public static final int INV_3 = 3;
    public static final BlockPos Fluid_IN = new BlockPos(3, 0, 3);
    public static final BlockPos Fluid_OUT = new BlockPos(1, 0, 3);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 1);
    public static final Set<BlockPos> Energy_IN = ImmutableSet.of((Object)new BlockPos(3, 1, 3));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 3));
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public MultiFluidTank[] tanks = new MultiFluidTank[]{new MultiFluidTank(24000), new MultiFluidTank(24000)};
    private int cooldownTicks = 0;
    private boolean wasActive = false;
    private static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(DistillationTowerTileEntity::getShape);

    public DistillationTowerTileEntity() {
        super((IETemplateMultiblock)DistillationTowerMultiblock.INSTANCE, 16000, true, null);
    }

    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)IPTileTypes.TOWER.get();
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.cooldownTicks = nbt.func_74762_e("cooldownTicks");
        if (!descPacket) {
            this.inventory = this.readInventory(nbt.func_74775_l("inventory"));
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("cooldownTicks", this.cooldownTicks);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)this.writeInventory(this.inventory));
        }
    }

    protected NonNullList<ItemStack> readInventory(CompoundNBT nbt) {
        NonNullList list = NonNullList.func_191196_a();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)list);
        if (list.size() == 0) {
            list = this.inventory.size() == 4 ? this.inventory : NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        } else if (list.size() < 4) {
            while (list.size() < 4) {
                list.add((Object)ItemStack.field_190927_a);
            }
        }
        return list;
    }

    protected CompoundNBT writeInventory(NonNullList<ItemStack> list) {
        return ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), list);
    }

    public void func_73660_a() {
        ItemStack emptyContainer;
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
        this.checkForNeedlessTicking();
        if (this.field_145850_b.field_72995_K || this.isDummy()) {
            return;
        }
        boolean update = false;
        if (!this.isRSDisabled()) {
            PoweredMultiblockTileEntity.MultiblockProcessInMachine process;
            DistillationRecipe recipe;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && this.tanks[0].getFluidAmount() > 0 && (recipe = DistillationRecipe.findRecipe(this.tanks[0].getFluid())) != null && this.tanks[0].getFluidAmount() >= recipe.getInputFluid().getAmount() && this.energyStorage.getEnergyStored() >= recipe.getTotalProcessEnergy() && this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)(process = new PoweredMultiblockTileEntity.MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]).setInputTanks(new int[]{0})), true)) {
                this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)process, false);
                update = true;
            }
            if (!this.processQueue.isEmpty()) {
                this.wasActive = true;
                this.cooldownTicks = 10;
                update = true;
            } else if (this.wasActive) {
                this.wasActive = false;
                update = true;
            }
            super.func_73660_a();
        }
        if (this.inventory.get(0) != ItemStack.field_190927_a && this.tanks[0].getFluidAmount() < this.tanks[0].getCapacity() && !(emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)))).func_190926_b()) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            update = true;
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            if (this.inventory.get(2) != ItemStack.field_190927_a && this.tanks[1].getFluidTypes() > 0) {
                MultiFluidTank outTank = this.tanks[1];
                for (int i = outTank.getFluidTypes() - 1; i >= 0; --i) {
                    ItemStack filledContainer;
                    FluidStack fs = outTank.getFluidInTank(i);
                    if (fs.getAmount() <= 0 || (filledContainer = DistillationTowerTileEntity.fillFluidContainer((IFluidTank)outTank, fs, (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3))).func_190926_b()) continue;
                    if (((ItemStack)this.inventory.get(3)).func_190916_E() == 1 && !Utils.isFluidContainerFull((ItemStack)filledContainer)) {
                        this.inventory.set(3, (Object)filledContainer.func_77946_l());
                    } else {
                        if (!((ItemStack)this.inventory.get(3)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer)) {
                            ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
                        } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                            this.inventory.set(3, (Object)filledContainer.func_77946_l());
                        }
                        ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                        if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                            this.inventory.set(2, (Object)ItemStack.field_190927_a);
                        }
                    }
                    update = true;
                    break;
                }
            }
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).func_177972_a(this.getFacing().func_176734_d());
            update |= FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outPos, (Direction)this.getFacing()).map(output -> {
                boolean ret = false;
                if (this.tanks[1].fluids.size() > 0) {
                    ArrayList<FluidStack> toDrain = new ArrayList<FluidStack>();
                    for (FluidStack target : this.tanks[1].fluids) {
                        FluidStack outStack = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 1000));
                        int accepted = output.fill(outStack, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) continue;
                        int drained = output.fill(FluidHelper.copyFluid(outStack, Math.min(outStack.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                        toDrain.add(new FluidStack(target.getFluid(), drained));
                        ret |= true;
                    }
                    toDrain.forEach(fluid -> this.tanks[1].drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
    }

    static ItemStack fillFluidContainer(IFluidTank tank, FluidStack fluid, ItemStack containerIn, ItemStack containerOut) {
        if (containerIn == null || containerIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        FluidActionResult result = DistillationTowerTileEntity.tryFillContainer(tank, fluid, containerIn, false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.func_190926_b() && containerOut.func_190916_E() + full.func_190916_E() > containerOut.func_77976_d()) {
                    return ItemStack.field_190927_a;
                }
                result = DistillationTowerTileEntity.tryFillContainer(tank, fluid, containerIn, true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    static FluidActionResult tryFillContainer(IFluidTank tank, FluidStack fluidSource, @Nonnull ItemStack container, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            int fillableAmount = containerFluidHandler.fill(fluidSource, IFluidHandler.FluidAction.SIMULATE);
            if (fillableAmount > 0) {
                if (doFill) {
                    FluidStack fs = new FluidStack(fluidSource, Math.min(fluidSource.getAmount(), fillableAmount));
                    containerFluidHandler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    protected DistillationRecipe getRecipeForId(ResourceLocation id) {
        return DistillationRecipe.recipes.get(id);
    }

    public Set<BlockPos> getEnergyPos() {
        return Energy_IN;
    }

    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        if (this.formed && this.isEnergyPos() && (facing == null || facing == Direction.UP)) {
            return IEEnums.IOSideConfig.INPUT;
        }
        return IEEnums.IOSideConfig.NONE;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public DistillationRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
        int outputAmount = 0;
        for (FluidStack outputFluid : ((DistillationRecipe)process.recipe).getFluidOutputs()) {
            outputAmount += outputFluid.getAmount();
        }
        return this.tanks[1].getCapacity() >= this.tanks[1].getFluidAmount() + outputAmount;
    }

    public void doProcessOutput(ItemStack output) {
        IItemHandler handler;
        Direction outputdir = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
        BlockPos outputpos = this.getBlockPosForPos(Item_OUT).func_177972_a(outputdir);
        TileEntity te = this.field_145850_b.func_175625_s(outputpos);
        if (te != null && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputdir.func_176734_d()).orElse(null)) != null) {
            output = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)output, (boolean)false);
        }
        if (!output.func_190926_b()) {
            Direction facing;
            double x = (double)outputpos.func_177958_n() + 0.5;
            double y = (double)outputpos.func_177956_o() + 0.25;
            double z = (double)outputpos.func_177952_p() + 0.5;
            Direction direction = facing = this.getIsMirrored() ? this.getFacing().func_176734_d() : this.getFacing();
            if (facing != Direction.EAST && facing != Direction.WEST) {
                x = (double)outputpos.func_177958_n() + (facing == Direction.SOUTH ? 0.15 : 0.85);
            }
            if (facing != Direction.NORTH && facing != Direction.SOUTH) {
                z = (double)outputpos.func_177952_p() + (facing == Direction.WEST ? 0.15 : 0.85);
            }
            ItemEntity ei = new ItemEntity(this.field_145850_b, x, y, z, output.func_77946_l());
            ei.func_213293_j(0.075 * (double)outputdir.func_82601_c(), 0.025, 0.075 * (double)outputdir.func_82599_e());
            this.field_145850_b.func_217376_c((Entity)ei);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
    }

    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
        return 1.0f;
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean shouldRenderAsActiveImpl() {
        return this.cooldownTicks > 0 || super.shouldRenderAsActiveImpl();
    }

    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
        if (master != null) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || (this.getIsMirrored() ? side == this.getFacing().func_176735_f() : side == this.getFacing().func_176746_e()))) {
                return new IFluidTank[]{master.tanks[0]};
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().func_176734_d())) {
                return new IFluidTank[]{master.tanks[1]};
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        if (this.posInMultiblock.equals((Object)Fluid_IN) && (this.getIsMirrored() ? side == null || side == this.getFacing().func_176735_f() : side == null || side == this.getFacing().func_176746_e())) {
            DistillationRecipe r1;
            DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
            if (master == null || master.tanks[0].getFluidAmount() >= master.tanks[0].getCapacity()) {
                return false;
            }
            FluidStack copy0 = Utils.copyFluidStackWithAmount((FluidStack)resource, (int)1000, (boolean)false);
            FluidStack copy1 = Utils.copyFluidStackWithAmount((FluidStack)master.tanks[0].getFluid(), (int)1000, (boolean)false);
            if (master.tanks[0].getFluid() == FluidStack.EMPTY) {
                DistillationRecipe r = DistillationRecipe.findRecipe(copy0);
                return r != null;
            }
            DistillationRecipe r0 = DistillationRecipe.findRecipe(copy0);
            return r0 == (r1 = DistillationRecipe.findRecipe(copy1));
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().func_176734_d())) {
            DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
            return master != null && master.tanks[1].getFluidAmount() > 0;
        }
        return false;
    }

    public boolean isLadder() {
        return this.posInMultiblock.func_177956_o() > 0 && this.posInMultiblock.func_177958_n() == 2 && this.posInMultiblock.func_177952_p() == 0;
    }

    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.func_177958_n();
        int bY = posInMultiblock.func_177956_o();
        int bZ = posInMultiblock.func_177952_p();
        if (bY < 2 && bX == 0 && bZ == 3) {
            if (bY == 1) {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
            }
            return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.125, 0.0, 0.75, 0.375, 1.0, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.375, 1.0, 0.25));
        }
        if (bY == 2 && bX == 3 && bZ == 2) {
            return Arrays.asList(new AxisAlignedBB(-0.0625, 0.375, 0.125, 0.0625, 1.125, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.5, 0.25, 0.75, 1.0, 0.75));
        }
        if (bY > 0 && bX == 1 && bZ == 3) {
            if (bY != 15) {
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                list.add(new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125));
                if (bY > 0 && bY % 4 == 0) {
                    list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
                }
                return list;
            }
            return Arrays.asList(new AxisAlignedBB(0.1875, 0.0, -0.0625, 0.8125, 0.625, 0.8125));
        }
        if (bY > 0 && bX == 2 && bZ == 0) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            list.add(new AxisAlignedBB(0.0625, bY == 1 ? 0.125 : 0.0, 0.875, 0.9375, 1.0, 1.0625));
            if (bY > 0 && bY % 4 == 0) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.875, 1.0, 1.0, 1.0625));
                list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.0625));
            }
            return list;
        }
        if (bX > 0 && bX < 3 && bZ > 0 && bZ < 3) {
            if (bY > 0) {
                AxisAlignedBB bb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
                if (bZ == 1) {
                    if (bX == 1) {
                        bb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 1.0, 1.0);
                    }
                    if (bX == 2) {
                        bb = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 1.0, 1.0);
                    }
                } else if (bZ == 2) {
                    if (bX == 1) {
                        bb = new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 1.0, 0.9375);
                    }
                    if (bX == 2) {
                        bb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 1.0, 0.9375);
                    }
                }
                return Arrays.asList(bb);
            }
            return Arrays.asList(new AxisAlignedBB(-0.125, 0.5, -0.125, 1.125, 1.125, 1.125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (bY > 0 && bY % 4 == 0) {
            return Arrays.asList(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 0) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            if (bX == 0 && bZ == 1 || bX == 1 && bZ == 3 || bX == 3 && bZ == 2 || bX == 3 && bZ == 3) {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            } else {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            }
            return list;
        }
        return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

