/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.gun;

import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.item.GunItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT})
public class ModelOverrides {
    private static final Map<Item, IOverrideModel> MODEL_MAP = new HashMap<Item, IOverrideModel>();

    public static void register(Item item, IOverrideModel model) {
        if (MODEL_MAP.putIfAbsent(item, model) == null) {
            MinecraftForge.EVENT_BUS.register((Object)model);
        }
    }

    public static boolean hasModel(ItemStack stack) {
        return MODEL_MAP.containsKey(stack.func_77973_b());
    }

    @Nullable
    public static IOverrideModel getModel(ItemStack stack) {
        return MODEL_MAP.get(stack.func_77973_b());
    }

    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT) {
            ModelOverrides.tick(event.player);
        }
    }

    private static void tick(PlayerEntity player) {
        IOverrideModel model;
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem && (model = ModelOverrides.getModel(heldItem)) != null) {
            model.tick(player);
        }
    }
}

