/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.entity.IHurtableMultipart;
import com.github.alexthe666.alexsmobs.message.MessageHurtMultipart;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityVoidWormPart
extends LivingEntity
implements IHurtableMultipart {
    protected static final EntitySize SIZE_BASE = EntitySize.func_220314_b((float)1.2f, (float)1.95f);
    protected static final EntitySize TAIL_SIZE = EntitySize.func_220314_b((float)1.6f, (float)2.0f);
    private static final DataParameter<Boolean> TAIL = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BODYINDEX = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WORM_SCALE = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> WORM_YAW = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> WORM_ANGLE = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> PARENT_UUID = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> CHILD_UUID = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> PORTAL_TICKS = EntityDataManager.func_187226_a(EntityVoidWormPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    public EntitySize multipartSize;
    public float prevWormAngle;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier = 1.0f;
    private float prevWormYaw = 0.0f;
    private Vector3d teleportPos = null;
    private Vector3d enterPos = null;
    private boolean doesParentControlPos = false;

    public EntityVoidWormPart(EntityType t, World world) {
        super(t, world);
        this.multipartSize = t.func_220334_j();
    }

    public EntityVoidWormPart(EntityType t, LivingEntity parent, float radius, float angleYaw, float offsetY) {
        super(t, parent.field_70170_p);
        this.setParent((Entity)parent);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f);
    }

    public void func_70108_f(Entity entityIn) {
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isTail() ? TAIL_SIZE.func_220313_a(this.func_213355_cm()) : super.func_213305_a(poseIn);
    }

    public float getWormScale() {
        return ((Float)this.field_70180_af.func_187225_a(WORM_SCALE)).floatValue();
    }

    public void setWormScale(float scale) {
        this.field_70180_af.func_187227_b(WORM_SCALE, (Object)Float.valueOf(scale));
    }

    public float func_213355_cm() {
        return this.getWormScale() + 0.5f;
    }

    public boolean func_184220_m(Entity entityIn) {
        if (!(entityIn instanceof AbstractMinecartEntity) && !(entityIn instanceof BoatEntity)) {
            return super.func_184220_m(entityIn);
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76380_i || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source.func_76347_k() || super.func_180431_b(source);
    }

    public Entity getEntity() {
        return this;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getParentId() != null) {
            compound.func_186854_a("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            compound.func_186854_a("ChildUUID", this.getChildId());
        }
        compound.func_74757_a("TailPart", this.isTail());
        compound.func_74768_a("BodyIndex", this.getBodyIndex());
        compound.func_74768_a("PortalTicks", this.getPortalTicks());
        compound.func_74776_a("PartAngle", this.angleYaw);
        compound.func_74776_a("WormScale", this.getWormScale());
        compound.func_74776_a("PartRadius", this.radius);
        compound.func_74776_a("PartYOffset", this.offsetY);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ParentUUID")) {
            this.setParentId(compound.func_186857_a("ParentUUID"));
        }
        if (compound.func_186855_b("ChildUUID")) {
            this.setChildId(compound.func_186857_a("ChildUUID"));
        }
        this.setTail(compound.func_74767_n("TailPart"));
        this.setBodyIndex(compound.func_74762_e("BodyIndex"));
        this.setPortalTicks(compound.func_74762_e("PortalTicks"));
        this.angleYaw = compound.func_74760_g("PartAngle");
        this.setWormScale(compound.func_74760_g("WormScale"));
        this.radius = compound.func_74760_g("PartRadius");
        this.offsetY = compound.func_74760_g("PartYOffset");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARENT_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(CHILD_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(TAIL, (Object)false);
        this.field_70180_af.func_187214_a(BODYINDEX, (Object)0);
        this.field_70180_af.func_187214_a(WORM_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(WORM_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PORTAL_TICKS, (Object)0);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.field_70180_af.func_187225_a(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_70180_af.func_187225_a(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public void setInitialPartPos(Entity parent) {
        this.func_70107_b(parent.field_70169_q + (double)this.radius * Math.cos((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw), parent.field_70167_r + (double)this.offsetY, parent.field_70166_s + (double)this.radius * Math.sin((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw));
    }

    public float getWormAngle() {
        return ((Float)this.field_70180_af.func_187225_a(WORM_ANGLE)).floatValue();
    }

    public void setWormAngle(float progress) {
        this.field_70180_af.func_187227_b(WORM_ANGLE, (Object)Float.valueOf(progress));
    }

    public int getPortalTicks() {
        return (Integer)this.field_70180_af.func_187225_a(PORTAL_TICKS);
    }

    public void setPortalTicks(int ticks) {
        this.field_70180_af.func_187227_b(PORTAL_TICKS, (Object)ticks);
    }

    public void func_70071_h_() {
        this.field_71087_bX = false;
        this.prevWormAngle = this.getWormAngle();
        this.prevWormYaw = ((Float)this.field_70180_af.func_187225_a(WORM_YAW)).floatValue();
        this.func_213317_d(Vector3d.field_186680_a);
        this.radius = 1.0f + this.getWormScale() * (this.isTail() ? 0.65f : 0.3f) + (this.getBodyIndex() == 0 ? 0.8f : 0.0f);
        if (this.field_70173_aa > 3) {
            Entity parent = this.getParent();
            this.func_213323_x_();
            if (parent != null && !this.field_70170_p.field_72995_K) {
                this.func_189654_d(true);
                Vector3d parentVec = parent.func_213303_ch().func_178786_a(parent.field_70169_q, parent.field_70167_r, parent.field_70166_s);
                double restrictRadius = MathHelper.func_151237_a((double)((double)this.radius - parentVec.func_189985_c() * 0.25), (double)(this.radius * 0.5f), (double)this.radius);
                if (parent instanceof EntityVoidWorm) {
                    restrictRadius *= (double)(this.isTail() ? 0.8f : 0.4f);
                }
                double x = parent.func_226277_ct_() + restrictRadius * Math.cos((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw);
                double yStretch = Math.abs(parent.func_226278_cu_() - parent.field_70167_r) > (double)this.func_213311_cf() ? parent.func_226278_cu_() : parent.field_70167_r;
                double y = yStretch + (double)(this.offsetY * this.getWormScale());
                double z = parent.func_226281_cx_() + restrictRadius * Math.sin((double)parent.field_70177_z * (Math.PI / 180) + (double)this.angleYaw);
                double d0 = parent.field_70169_q - this.func_226277_ct_();
                double d1 = parent.field_70167_r - this.func_226278_cu_();
                double d2 = parent.field_70166_s - this.func_226281_cx_();
                float yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float pitch = parent.field_70125_A;
                if (this.getPortalTicks() <= 1 && !this.doesParentControlPos) {
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                    this.func_70107_b(x, y, z);
                    this.field_70125_A = this.limitAngle(this.field_70125_A, f2, 5.0f);
                    this.field_70177_z = yaw;
                    this.field_70180_af.func_187227_b(WORM_YAW, (Object)Float.valueOf(this.field_70177_z));
                }
                this.func_70018_K();
                this.field_70759_as = this.field_70177_z;
                this.field_70761_aq = pitch;
                if (parent instanceof LivingEntity && !this.field_70170_p.field_72995_K && (((LivingEntity)parent).field_70737_aN > 0 || ((LivingEntity)parent).field_70725_aQ > 0)) {
                    AlexsMobs.sendMSGToAll(new MessageHurtMultipart(this.func_145782_y(), parent.func_145782_y(), 0.0f));
                    this.field_70737_aN = ((LivingEntity)parent).field_70737_aN;
                    this.field_70725_aQ = ((LivingEntity)parent).field_70725_aQ;
                }
                this.func_85033_bc();
                if (parent.field_70128_L && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
                if (parent instanceof EntityVoidWorm) {
                    this.setWormAngle(((EntityVoidWorm)parent).prevWormAngle);
                } else if (parent instanceof EntityVoidWormPart) {
                    this.setWormAngle(((EntityVoidWormPart)parent).prevWormAngle);
                }
            } else if (this.field_70173_aa > 20 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        if (this.field_70173_aa % 400 == 0) {
            this.func_70691_i(1.0f);
        }
        super.func_70071_h_();
        if (this.doesParentControlPos && this.enterPos != null) {
            this.func_70634_a(this.enterPos.field_72450_a, this.enterPos.field_72448_b, this.enterPos.field_72449_c);
        }
        if (this.getPortalTicks() > 0) {
            this.setPortalTicks(this.getPortalTicks() - 1);
            if (this.getPortalTicks() <= 5 && this.teleportPos != null) {
                Vector3d vec = this.teleportPos;
                this.func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                this.field_70142_S = vec.field_72450_a;
                this.field_70137_T = vec.field_72448_b;
                this.field_70136_U = vec.field_72449_c;
                if (this.getPortalTicks() == 5 && this.getChild() instanceof EntityVoidWormPart) {
                    ((EntityVoidWormPart)this.getChild()).teleportTo(this.enterPos, this.teleportPos);
                }
                this.teleportPos = null;
            } else if (this.getPortalTicks() > 5 && this.enterPos != null) {
                this.func_70634_a(this.enterPos.field_72450_a, this.enterPos.field_72448_b, this.enterPos.field_72449_c);
            }
            if (this.getPortalTicks() == 0) {
                this.doesParentControlPos = false;
            }
        }
    }

    protected float limitAngle(float sourceAngle, float targetAngle, float maximumChange) {
        float f1;
        float f = MathHelper.func_76142_g((float)(targetAngle - sourceAngle));
        if (f > maximumChange) {
            f = maximumChange;
        }
        if (f < -maximumChange) {
            f = -maximumChange;
        }
        if ((f1 = sourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.remove(false);
            for (int i = 0; i < 30; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.WORM_PORTAL, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        EntityVoidWorm worm = this.getWorm();
        if (worm != null) {
            int segments = Math.max(worm.getSegmentCount() / 2 - 1, 1);
            worm.setSegmentCount(segments);
            if (this.getChild() instanceof EntityVoidWormPart) {
                EntityVoidWormPart segment = (EntityVoidWormPart)this.getChild();
                EntityVoidWorm worm2 = (EntityVoidWorm)AMEntityRegistry.VOID_WORM.func_200721_a(this.field_70170_p);
                worm2.func_82149_j((Entity)this);
                segment.func_82149_j((Entity)this);
                worm2.setChildId(segment.func_110124_au());
                worm2.setSegmentCount(segments);
                segment.setParent((Entity)worm2);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)worm2);
                }
                worm2.setSplitter(true);
                worm2.setMaxHealth(worm.func_110138_aP() / 2.0f, true);
                worm2.setSplitFromUuid(worm.func_110124_au());
                worm2.setWormSpeed((float)MathHelper.func_151237_a((double)((double)worm.getWormSpeed() * 0.8), (double)0.4f, (double)1.0));
                worm2.resetWormScales();
                if (!this.field_70170_p.field_72995_K && cause != null && cause.func_76346_g() instanceof ServerPlayerEntity) {
                    AMAdvancementTriggerRegistry.VOID_WORM_SPLIT.trigger((ServerPlayerEntity)cause.func_76346_g());
                }
            }
            worm.resetWormScales();
        }
    }

    public void func_70106_y() {
        this.remove(false);
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityVoidWorm worm = this.getWorm();
        return super.func_184191_r(entityIn) || worm != null && worm.func_184191_r(entityIn);
    }

    public EntityVoidWorm getWorm() {
        Entity parent = this.getParent();
        while (parent instanceof EntityVoidWormPart) {
            parent = ((EntityVoidWormPart)parent).getParent();
        }
        if (parent instanceof EntityVoidWorm) {
            return (EntityVoidWorm)parent;
        }
        return null;
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.func_110124_au());
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean func_70067_L() {
        return true;
    }

    public HandSide func_184591_cq() {
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> !entity.func_70028_i(parent) && !(entity instanceof EntityVoidWormPart) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f(parent));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        Entity parent = this.getParent();
        return parent != null ? parent.func_184230_a(player, hand) : ActionResultType.PASS;
    }

    public boolean isHurt() {
        return (double)this.func_110143_aJ() <= this.getHealthThreshold();
    }

    public double getHealthThreshold() {
        return 5.0;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (super.func_70097_a(source, damage)) {
            EntityVoidWorm worm = this.getWorm();
            if (worm != null) {
                worm.playHurtSoundWorm(source);
            }
            return true;
        }
        return false;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public boolean isTail() {
        return (Boolean)this.field_70180_af.func_187225_a(TAIL);
    }

    public void setTail(boolean tail) {
        this.field_70180_af.func_187227_b(TAIL, (Object)tail);
    }

    public int getBodyIndex() {
        return (Integer)this.field_70180_af.func_187225_a(BODYINDEX);
    }

    public void setBodyIndex(int index) {
        this.field_70180_af.func_187227_b(BODYINDEX, (Object)index);
    }

    public boolean shouldNotExist() {
        Entity parent = this.getParent();
        return !parent.func_70089_S();
    }

    @Override
    public void onAttackedFromServer(LivingEntity parent, float damage) {
        if (parent.field_70725_aQ > 0) {
            this.field_70725_aQ = parent.field_70725_aQ;
        }
        if (parent.field_70737_aN > 0) {
            this.field_70737_aN = parent.field_70737_aN;
        }
    }

    public boolean shouldContinuePersisting() {
        return this.isAddedToWorld() || this.field_70128_L;
    }

    public float getWormYaw(float partialTicks) {
        return partialTicks == 0.0f ? ((Float)this.field_70180_af.func_187225_a(WORM_YAW)).floatValue() : this.prevWormYaw + (((Float)this.field_70180_af.func_187225_a(WORM_YAW)).floatValue() - this.prevWormYaw) * partialTicks;
    }

    public void teleportTo(Vector3d enterPos, Vector3d to) {
        this.setPortalTicks(10);
        this.teleportPos = to;
        this.enterPos = enterPos;
        EntityVoidWorm worm = this.getWorm();
        if (worm != null && this.getChild() == null) {
            worm.fullyThrough = true;
        }
    }
}

