/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.ClientHandler;
import com.mrcrayfish.guns.client.CustomGunManager;
import com.mrcrayfish.guns.common.BoundingBoxManager;
import com.mrcrayfish.guns.common.ProjectileManager;
import com.mrcrayfish.guns.crafting.WorkbenchIngredient;
import com.mrcrayfish.guns.datagen.BlockTagGen;
import com.mrcrayfish.guns.datagen.GunGen;
import com.mrcrayfish.guns.datagen.ItemTagGen;
import com.mrcrayfish.guns.datagen.LanguageGen;
import com.mrcrayfish.guns.datagen.LootTableGen;
import com.mrcrayfish.guns.datagen.RecipeGen;
import com.mrcrayfish.guns.enchantment.EnchantmentTypes;
import com.mrcrayfish.guns.entity.GrenadeEntity;
import com.mrcrayfish.guns.entity.MissileEntity;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModContainers;
import com.mrcrayfish.guns.init.ModEffects;
import com.mrcrayfish.guns.init.ModEnchantments;
import com.mrcrayfish.guns.init.ModEntities;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.init.ModParticleTypes;
import com.mrcrayfish.guns.init.ModRecipeSerializers;
import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.init.ModTileEntities;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cgm")
public class GunMod {
    public static boolean controllableLoaded = false;
    public static boolean backpackedLoaded = false;
    public static final Logger LOGGER = LogManager.getLogger((String)"cgm");
    public static final ItemGroup GROUP = new ItemGroup("cgm"){

        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.PISTOL.get());
            stack.func_196082_o().func_74768_a("AmmoCount", ((GunItem)ModItems.PISTOL.get()).getGun().getGeneral().getMaxAmmo());
            return stack;
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            CustomGunManager.fill(items);
        }
    }.func_111229_a(new EnchantmentType[]{EnchantmentTypes.GUN, EnchantmentTypes.SEMI_AUTO_GUN});

    public GunMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.REGISTER.register(bus);
        ModContainers.REGISTER.register(bus);
        ModEffects.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModEntities.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModParticleTypes.REGISTER.register(bus);
        ModRecipeSerializers.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        ModTileEntities.REGISTER.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onGatherData);
        controllableLoaded = ModList.get().isLoaded("controllable");
        backpackedLoaded = ModList.get().isLoaded("backpacked");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModSyncedDataKeys.register();
            CraftingHelper.register((ResourceLocation)new ResourceLocation("cgm", "workbench_ingredient"), (IIngredientSerializer)WorkbenchIngredient.Serializer.INSTANCE);
            ProjectileManager.getInstance().registerFactory((Item)ModItems.GRENADE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new GrenadeEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.GRENADE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.MISSILE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new MissileEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.MISSILE.get()), worldIn, entity, weapon, item, modifiedGun));
            PacketHandler.init();
            if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
                MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
            }
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientHandler.setup();
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagGen blockTagGen = new BlockTagGen(generator, existingFileHelper);
        generator.func_200390_a((IDataProvider)new RecipeGen(generator));
        generator.func_200390_a((IDataProvider)new LootTableGen(generator));
        generator.func_200390_a((IDataProvider)blockTagGen);
        generator.func_200390_a((IDataProvider)new ItemTagGen(generator, blockTagGen, existingFileHelper));
        generator.func_200390_a((IDataProvider)new LanguageGen(generator));
        generator.func_200390_a((IDataProvider)new GunGen(generator));
    }
}

