/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.crafting;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.guns.crafting.RecipeType;
import com.mrcrayfish.guns.crafting.WorkbenchIngredient;
import com.mrcrayfish.guns.init.ModRecipeSerializers;
import com.mrcrayfish.guns.tileentity.WorkbenchTileEntity;
import com.mrcrayfish.guns.util.InventoryUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class WorkbenchRecipe
implements IRecipe<WorkbenchTileEntity> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<WorkbenchIngredient> materials;

    public WorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<WorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.func_77946_l();
    }

    public ImmutableList<WorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(WorkbenchTileEntity inv, World worldIn) {
        return false;
    }

    public ItemStack assemble(WorkbenchTileEntity inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.item.func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.WORKBENCH.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeType.WORKBENCH;
    }

    public boolean hasMaterials(PlayerEntity player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            if (InventoryUtil.hasWorkstationIngredient(player, ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(PlayerEntity player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            InventoryUtil.removeWorkstationIngredient(player, ingredient);
        }
    }
}

