/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.guns.common.Gun;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GunProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Gun> gunMap = new HashMap<ResourceLocation, Gun>();

    protected GunProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerGuns();

    protected final void addGun(ResourceLocation id, Gun gun) {
        this.gunMap.put(id, gun);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.gunMap.clear();
        this.registerGuns();
        this.gunMap.forEach((id, gun) -> {
            Path path = this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/guns/" + id.func_110623_a() + ".json");
            try {
                JsonObject object = gun.toJsonObject();
                String rawJson = GSON.toJson((JsonElement)object);
                String hash = field_208307_a.hashUnencodedChars((CharSequence)rawJson).toString();
                if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(rawJson);
                    }
                }
                cache.func_208316_a(path, hash);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Guns: cgm";
    }
}

