/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.sphere;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class SphereChiselMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final int diameter;
    private final IFormattableTextComponent displayName;
    private final IFormattableTextComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    SphereChiselMode(int diameter, IFormattableTextComponent displayName, IFormattableTextComponent multiLineDisplayName, ResourceLocation iconName) {
        this.diameter = diameter;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, Vector3d> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()), facing -> facing.func_216372_d(-1.0, -1.0, -1.0));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (!rayTraceHandle.right().isPresent()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        context.setMetadata((IMetadataKey)ModMetadataKeys.ANCHOR.get(), (Vector3d)rayTraceHandle.right().get());
        return context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                mutator.inWorldMutableStream().forEach(state -> {
                    if (!filter.test((IStateEntryInfo)state)) {
                        return;
                    }
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, Vector3d> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (!rayTraceHandle.right().isPresent()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        context.setMetadata((IMetadataKey)ModMetadataKeys.ANCHOR.get(), (Vector3d)rayTraceHandle.right().get());
        return context.getMutator().map(mutator -> {
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.func_184812_l_()) {
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public boolean isStillValid(PlayerEntity playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Vector3d> rayTraceHandle = this.processRayTraceIntoCenter(playerEntity, face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), Function.identity());
        Optional contextAnchor = context.getMetadata((IMetadataKey)ModMetadataKeys.ANCHOR.get());
        return rayTraceHandle.map(d -> contextAnchor.filter(arg_0 -> ((Vector3d)d).equals(arg_0)).isPresent()).orElseGet(() -> !contextAnchor.isPresent());
    }

    private Either<ClickProcessingState, Vector3d> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context, Function<Direction, Vector3d> placementFacingAdapter, Function<Vector3d, Vector3d> fullFacingVectorAdapter) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Either.left((Object)ClickProcessingState.DEFAULT);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vector3d centeredHitVector = Vector3d.func_237491_b_((Vector3i)new BlockPos(hitVector.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        Vector3d center = centeredHitVector.func_178787_e(new Vector3d((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).func_216369_h(fullFacingVectorAdapter.apply(Vector3d.func_237491_b_((Vector3i)blockRayTraceResult.func_216354_b().func_176730_m()))));
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                return new SphereAreaFilter(context.getModeOfOperandus(), ((IWorldAreaAccessor)areaAccessor).getInWorldStartPoint(), center);
            }
            return new SphereAreaFilter(context.getModeOfOperandus(), Vector3d.field_186680_a, center);
        });
        BlockPosStreamProvider.getForRange(this.diameter).forEach(bitPos -> {
            Vector3d target = center.func_178787_e(Vector3d.func_237491_b_((Vector3i)bitPos.func_177973_b(new Vector3i(this.diameter / 2, this.diameter / 2, this.diameter / 2))).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            context.include(target);
        });
        return Either.right((Object)center);
    }

    private Optional<Vector3d> processRayTraceIntoCenter(PlayerEntity playerEntity, Function<Direction, Vector3d> placementFacingAdapter, Function<Vector3d, Vector3d> fullFacingVectorAdapter) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.empty();
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vector3d centeredHitVector = Vector3d.func_237491_b_((Vector3i)new BlockPos(hitVector.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        Vector3d center = centeredHitVector.func_178787_e(new Vector3d((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).func_216369_h(fullFacingVectorAdapter.apply(Vector3d.func_237491_b_((Vector3i)blockRayTraceResult.func_216354_b().func_176730_m()))));
        return Optional.of(center);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ITextComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.SPHERE);
    }

    private final class SphereAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final ChiselingOperation modeOfOperandus;
        private final Vector3d startPoint;
        private final Vector3d center;

        private SphereAreaFilter(ChiselingOperation modeOfOperandus, Vector3d startPoint, Vector3d center) {
            this.modeOfOperandus = modeOfOperandus;
            this.startPoint = startPoint;
            this.center = center;
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            return inWorldStateEntryInfo.getInWorldStartPoint().func_72438_d(this.center) <= (double)((float)SphereChiselMode.this.diameter / 2.0f / (float)StateEntrySize.current().getBitsPerBlockSide()) && (!stateEntryInfo.getState().func_196958_f() || this.modeOfOperandus.processesAir());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereAreaFilter)) {
                return false;
            }
            SphereAreaFilter that = (SphereAreaFilter)o;
            if (!Objects.equals(this.startPoint, that.startPoint)) {
                return false;
            }
            return Objects.equals(this.center, that.center);
        }

        public int hashCode() {
            int result = this.startPoint != null ? this.startPoint.hashCode() : 0;
            result = 31 * result + (this.center != null ? this.center.hashCode() : 0);
            return result;
        }
    }
}

