/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.reloading;

import com.google.common.collect.Sets;
import java.util.Set;
import mod.chiselsandbits.api.reloading.ICacheClearingHandler;
import mod.chiselsandbits.client.besr.BitStorageBESR;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientResourceReloadingManager
implements IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ClientResourceReloadingManager INSTANCE = new ClientResourceReloadingManager();
    private final Set<ICacheClearingHandler> cacheClearingHandlers = Sets.newConcurrentHashSet();

    public static ClientResourceReloadingManager getInstance() {
        return INSTANCE;
    }

    private ClientResourceReloadingManager() {
    }

    public void func_195410_a(@NotNull IResourceManager manager) {
        LOGGER.info("Resetting client caches");
        this.cacheClearingHandlers.forEach(ICacheClearingHandler::clear);
    }

    public ClientResourceReloadingManager registerCacheClearer(ICacheClearingHandler cacheClearingHandler) {
        this.cacheClearingHandlers.add(cacheClearingHandler);
        return this;
    }

    public static void setup() {
        LOGGER.info("Setting up client reloading resource manager.");
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
            reloadableResourceManager.func_219534_a((IFutureReloadListener)ClientResourceReloadingManager.getInstance());
        }
        ClientResourceReloadingManager.getInstance().registerCacheClearer(BitStorageBESR::clearCache).registerCacheClearer(BitBlockBakedModelManager.getInstance()::clearCache).registerCacheClearer(ChiseledBlockBakedModelManager.getInstance()::clearCache).registerCacheClearer(FaceManager.getInstance()::clearCache);
    }
}

