/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class ComputerBorderRenderer {
    public static final ResourceLocation BACKGROUND_NORMAL = new ResourceLocation("computercraft", "textures/gui/corners_normal.png");
    public static final ResourceLocation BACKGROUND_ADVANCED = new ResourceLocation("computercraft", "textures/gui/corners_advanced.png");
    public static final ResourceLocation BACKGROUND_COMMAND = new ResourceLocation("computercraft", "textures/gui/corners_command.png");
    public static final ResourceLocation BACKGROUND_COLOUR = new ResourceLocation("computercraft", "textures/gui/corners_colour.png");
    private static final Matrix4f IDENTITY = new Matrix4f();
    public static final int MARGIN = 2;
    public static final int BORDER = 12;
    private static final int CORNER_TOP_Y = 28;
    private static final int CORNER_BOTTOM_Y = 40;
    private static final int CORNER_LEFT_X = 12;
    private static final int CORNER_RIGHT_X = 24;
    private static final int BORDER_RIGHT_X = 36;
    private static final int LIGHT_BORDER_Y = 56;
    private static final int LIGHT_CORNER_Y = 80;
    public static final int LIGHT_HEIGHT = 8;
    public static final int TEX_SIZE = 256;
    private static final float TEX_SCALE = 0.00390625f;
    private final Matrix4f transform;
    private final IVertexBuilder builder;
    private final int z;
    private final float r;
    private final float g;
    private final float b;
    private final int light;

    public ComputerBorderRenderer(Matrix4f transform, IVertexBuilder builder, int z, int light, float r, float g, float b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Nonnull
    public static ResourceLocation getTexture(@Nonnull ComputerFamily family) {
        switch (family) {
            default: {
                return BACKGROUND_NORMAL;
            }
            case ADVANCED: {
                return BACKGROUND_ADVANCED;
            }
            case COMMAND: 
        }
        return BACKGROUND_COMMAND;
    }

    public static RenderType getRenderType(ResourceLocation location) {
        return RenderType.func_228658_l_((ResourceLocation)location);
    }

    public static void render(ResourceLocation location, int x, int y, int z, int light, int width, int height) {
        IRenderTypeBuffer.Impl source = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ComputerBorderRenderer.render(IDENTITY, source.getBuffer(ComputerBorderRenderer.getRenderType(location)), x, y, z, light, width, height, false, 1.0f, 1.0f, 1.0f);
        source.func_228461_a_();
    }

    public static void render(Matrix4f transform, IVertexBuilder buffer, int x, int y, int z, int light, int width, int height, boolean withLight, float r, float g, float b) {
        new ComputerBorderRenderer(transform, buffer, z, light, r, g, b).doRender(x, y, width, height, withLight);
    }

    public void doRender(int x, int y, int width, int height, boolean withLight) {
        int endX = x + width;
        int endY = y + height;
        this.renderLine(x - 12, y, 0, 28, 12, endY - y);
        this.renderLine(endX, y, 36, 28, 12, endY - y);
        this.renderLine(x, y - 12, 0, 0, endX - x, 12);
        this.renderCorner(x - 12, y - 12, 12, 28);
        this.renderCorner(endX, y - 12, 24, 28);
        if (withLight) {
            this.renderTexture(x, endY, 0, 56, endX - x, 20, 12, 20);
            this.renderTexture(x - 12, endY, 12, 80, 12, 20);
            this.renderTexture(endX, endY, 24, 80, 12, 20);
        } else {
            this.renderLine(x, endY, 0, 12, endX - x, 12);
            this.renderCorner(x - 12, endY, 12, 40);
            this.renderCorner(endX, endY, 24, 40);
        }
    }

    private void renderCorner(int x, int y, int u, int v) {
        this.renderTexture(x, y, u, v, 12, 12, 12, 12);
    }

    private void renderLine(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, 12, 12);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, width, height);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        this.builder.func_227888_a_(this.transform, (float)x, (float)(y + height), (float)this.z).func_227885_a_(this.r, this.g, this.b, 1.0f).func_225583_a_((float)u * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).func_227886_a_(this.light).func_181675_d();
        this.builder.func_227888_a_(this.transform, (float)(x + width), (float)(y + height), (float)this.z).func_227885_a_(this.r, this.g, this.b, 1.0f).func_225583_a_((float)(u + textureWidth) * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).func_227886_a_(this.light).func_181675_d();
        this.builder.func_227888_a_(this.transform, (float)(x + width), (float)y, (float)this.z).func_227885_a_(this.r, this.g, this.b, 1.0f).func_225583_a_((float)(u + textureWidth) * 0.00390625f, (float)v * 0.00390625f).func_227886_a_(this.light).func_181675_d();
        this.builder.func_227888_a_(this.transform, (float)x, (float)y, (float)this.z).func_227885_a_(this.r, this.g, this.b, 1.0f).func_225583_a_((float)u * 0.00390625f, (float)v * 0.00390625f).func_227886_a_(this.light).func_181675_d();
    }

    static {
        IDENTITY.func_226591_a_();
    }
}

