/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ItemPocketRenderer
extends ItemMapLikeRenderer {
    private static final ItemPocketRenderer INSTANCE = new ItemPocketRenderer();

    private ItemPocketRenderer() {
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.func_77973_b() instanceof ItemPocketComputer)) {
            return;
        }
        event.setCanceled(true);
        INSTANCE.renderItemFirstPerson(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack());
    }

    @Override
    protected void renderItem(MatrixStack transform, IRenderTypeBuffer bufferSource, ItemStack stack, int light) {
        int termHeight;
        int termWidth;
        Terminal terminal;
        ClientComputer computer = ItemPocketComputer.createClientComputer(stack);
        Terminal terminal2 = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = ComputerCraft.pocketTermWidth;
            termHeight = ComputerCraft.pocketTermHeight;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.func_227860_a_();
        transform.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        transform.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        transform.func_227862_a_(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.func_227862_a_(scale, scale, 0.0f);
        transform.func_227861_a_(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        ItemPocketComputer item = (ItemPocketComputer)stack.func_77973_b();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
        ItemPocketRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = ItemPocketComputer.getLightState(stack);
        if (lightColour == -1) {
            lightColour = Colour.BLACK.getHex();
        }
        ItemPocketRenderer.renderLight(matrix, bufferSource, lightColour, width, height);
        if (computer != null && terminal != null) {
            FixedWidthFontRenderer.drawTerminal(matrix, bufferSource.getBuffer(RenderTypes.TERMINAL_WITHOUT_DEPTH), 2.0f, 2.0f, terminal, !computer.isColour(), 2.0f, 2.0f, 2.0f, 2.0f);
            FixedWidthFontRenderer.drawBlocker(matrix, bufferSource.getBuffer(RenderTypes.TERMINAL_BLOCKER), 0.0f, 0.0f, width, height);
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(matrix, bufferSource.getBuffer(RenderTypes.TERMINAL_WITH_DEPTH), 0.0f, 0.0f, width, height);
        }
        transform.func_227865_b_();
    }

    private static void renderFrame(Matrix4f transform, IRenderTypeBuffer bufferSource, ComputerFamily family, int colour, int light, int width, int height) {
        ResourceLocation texture = colour != -1 ? ComputerBorderRenderer.BACKGROUND_COLOUR : ComputerBorderRenderer.getTexture(family);
        float r = (float)(colour >>> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >>> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        ComputerBorderRenderer.render(transform, bufferSource.getBuffer(ComputerBorderRenderer.getRenderType(texture)), 0, 0, 0, light, width, height, true, r, g, b);
    }

    private static void renderLight(Matrix4f transform, IRenderTypeBuffer bufferSource, int colour, int width, int height) {
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        byte[] c = new byte[]{r, g, b, -1};
        IVertexBuilder buffer = bufferSource.getBuffer(RenderTypes.TERMINAL_WITH_DEPTH);
        FixedWidthFontRenderer.drawQuad(transform, buffer, width - 16, (float)height + 6.0f, 0.001f, 16.0f, 8.0f, c, 0xF000F0);
    }
}

