/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.tracking.TrackingField;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAPIEnvironment {
    public static final String TIMER_EVENT = "timer";

    public int getComputerID();

    @Nonnull
    public IComputerEnvironment getComputerEnvironment();

    @Nonnull
    public IWorkMonitor getMainThreadMonitor();

    @Nonnull
    public Terminal getTerminal();

    public FileSystem getFileSystem();

    public void shutdown();

    public void reboot();

    public void queueEvent(String var1, Object ... var2);

    public void setOutput(ComputerSide var1, int var2);

    public int getOutput(ComputerSide var1);

    public int getInput(ComputerSide var1);

    public void setBundledOutput(ComputerSide var1, int var2);

    public int getBundledOutput(ComputerSide var1);

    public int getBundledInput(ComputerSide var1);

    public void setPeripheralChangeListener(@Nullable IPeripheralChangeListener var1);

    @Nullable
    public IPeripheral getPeripheral(ComputerSide var1);

    @Nullable
    public String getLabel();

    public void setLabel(@Nullable String var1);

    public int startTimer(long var1);

    public void cancelTimer(int var1);

    public void addTrackingChange(@Nonnull TrackingField var1, long var2);

    default public void addTrackingChange(@Nonnull TrackingField field) {
        this.addTrackingChange(field, 1L);
    }

    @FunctionalInterface
    public static interface IPeripheralChangeListener {
        public void onPeripheralChanged(ComputerSide var1, @Nullable IPeripheral var2);
    }
}

