/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.core.tracking.ComputerMBean;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Container;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

@Mod.EventBusSubscriber(modid="computercraft")
public final class CommonHooks {
    public static final ResourceLocation LOOT_TREASURE_DISK = new ResourceLocation("computercraft", "treasure_disk");
    private static final Set<ResourceLocation> TABLES = new HashSet<ResourceLocation>(Arrays.asList(LootTables.field_186422_d, LootTables.field_186424_f, LootTables.field_186428_j, LootTables.field_186427_i, LootTables.field_186426_h, LootTables.field_186429_k, LootTables.field_186430_l, LootTables.field_186431_m, LootTables.field_191192_o, LootTables.field_215817_h));

    private CommonHooks() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            MainThread.executePendingTasks();
            ComputerCraft.serverComputerRegistry.update();
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        IComputer computer;
        Container container = event.getContainer();
        if (container instanceof IContainerComputer && (computer = ((IContainerComputer)container).getComputer()) instanceof ServerComputer) {
            ((ServerComputer)computer).sendTerminalState(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        CommandComputerCraft.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        if (server instanceof DedicatedServer && ((DedicatedServer)server).func_213221_d_().field_241079_P_) {
            ComputerMBean.register();
        }
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        ComputerCraft.serverComputerRegistry.reset();
        WirelessNetwork.resetNetworks();
        Tracking.reset();
        ComputerMBean.registerTracker();
        NetworkUtils.reset();
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        ComputerCraft.serverComputerRegistry.reset();
        WirelessNetwork.resetNetworks();
        Tracking.reset();
        NetworkUtils.reset();
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (!name.func_110624_b().equals("minecraft") || !TABLES.contains(name)) {
            return;
        }
        event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)LOOT_TREASURE_DISK)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).name("computercraft_treasure").func_216044_b());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ResourceMount.RELOAD_LISTENER);
    }

    @SubscribeEvent
    public static void onMissingEntityMappingsEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        ResourceLocation id = new ResourceLocation("computercraft", "turtle_player");
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("computercraft")) {
            if (!mapping.key.equals((Object)id)) continue;
            mapping.ignore();
        }
    }
}

