/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.media.items.ItemPrintout;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public final class PrintoutRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<?> SERIALIZER = new SpecialRecipeSerializer(PrintoutRecipe::new);

    private PrintoutRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean func_194133_a(int x, int y) {
        return x >= 3 && y >= 3;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemPrintout.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return !this.assemble(inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inventory) {
        int numPages = 0;
        int numPrintouts = 0;
        ItemStack[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        for (int y = 0; y < inventory.func_174923_h(); ++y) {
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack stack = inventory.func_70301_a(x + y * inventory.func_174922_i());
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof ItemPrintout && ((ItemPrintout)stack.func_77973_b()).getType() != ItemPrintout.Type.BOOK) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += ItemPrintout.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (stack.func_77973_b() == Items.field_151121_aF) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (Tags.Items.STRING.func_230235_a_((Object)stack.func_77973_b()) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (Tags.Items.LEATHER.func_230235_a_((Object)stack.func_77973_b()) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                ItemStack stack = printouts[printout];
                if (stack.func_77973_b() instanceof ItemPrintout) {
                    String[] pageText = ItemPrintout.getText(printouts[printout]);
                    String[] pageColours = ItemPrintout.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].func_77973_b() instanceof ItemPrintout) {
                title = ItemPrintout.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return ItemPrintout.createBookFromTitleAndText(title, text, colours);
            }
            return ItemPrintout.createMultipleFromTitleAndText(title, text, colours);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

