/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MouseEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_CLICK = 0;
    public static final int TYPE_DRAG = 1;
    public static final int TYPE_UP = 2;
    public static final int TYPE_SCROLL = 3;
    private final int type;
    private final int x;
    private final int y;
    private final int arg;

    public MouseEventServerMessage(int instanceId, int type, int arg, int x, int y) {
        super(instanceId);
        this.type = type;
        this.arg = arg;
        this.x = x;
        this.y = y;
    }

    public MouseEventServerMessage(@Nonnull PacketBuffer buf) {
        super(buf);
        this.type = buf.readByte();
        this.arg = buf.func_150792_a();
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.type);
        buf.func_150787_b(this.arg);
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        InputState input = container.getInput();
        switch (this.type) {
            case 0: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case 1: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case 2: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case 3: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }
}

