/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSpeaker
extends TileGeneric
implements ITickableTileEntity {
    private final SpeakerPeripheral peripheral = new Peripheral(this);
    private LazyOptional<IPeripheral> peripheralCap;

    public TileSpeaker(TileEntityType<TileSpeaker> type) {
        super(type);
    }

    public void func_73660_a() {
        this.peripheral.update();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkHandler.sendToAllPlayers(new SpeakerStopClientMessage(this.peripheral.getSource()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    private static final class Peripheral
    extends SpeakerPeripheral {
        private final TileSpeaker speaker;

        private Peripheral(TileSpeaker speaker) {
            this.speaker = speaker;
        }

        @Override
        public World getWorld() {
            return this.speaker.func_145831_w();
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            return Vector3d.func_237489_a_((Vector3i)this.speaker.func_174877_v());
        }

        @Override
        public boolean equals(@Nullable IPeripheral other) {
            return this == other || other instanceof Peripheral && this.speaker == ((Peripheral)other).speaker;
        }
    }
}

