/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.Colour;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class Palette {
    private static final int PALETTE_SIZE = 16;
    private final double[][] colours = new double[16][3];
    private final byte[][] byteColours = new byte[16][4];
    private final byte[][] greyByteColours = new byte[16][4];
    public static final Palette DEFAULT = new Palette();

    public Palette() {
        this.resetColours();
        for (int i = 0; i < 16; ++i) {
            this.greyByteColours[i][3] = -1;
            this.byteColours[i][3] = -1;
        }
    }

    public void setColour(int i, double r, double g, double b) {
        byte grey;
        if (i < 0 || i >= this.colours.length) {
            return;
        }
        this.colours[i][0] = r;
        this.colours[i][1] = g;
        this.colours[i][2] = b;
        this.byteColours[i][0] = (byte)(r * 255.0);
        this.byteColours[i][1] = (byte)(g * 255.0);
        this.byteColours[i][2] = (byte)(b * 255.0);
        byte by = grey = (byte)((r + g + b) / 3.0 * 255.0);
        this.greyByteColours[i][2] = by;
        this.greyByteColours[i][1] = by;
        this.greyByteColours[i][0] = by;
    }

    public void setColour(int i, Colour colour) {
        this.setColour(i, colour.getR(), colour.getG(), colour.getB());
    }

    public double[] getColour(int i) {
        return i >= 0 && i < this.colours.length ? this.colours[i] : null;
    }

    @Nonnull
    public byte[] getByteColour(int i, boolean greyscale) {
        return greyscale ? this.greyByteColours[i] : this.byteColours[i];
    }

    public void resetColour(int i) {
        if (i >= 0 && i < this.colours.length) {
            this.setColour(i, Colour.VALUES[i]);
        }
    }

    public void resetColours() {
        for (int i = 0; i < Colour.VALUES.length; ++i) {
            this.resetColour(i);
        }
    }

    public static int encodeRGB8(double[] rgb) {
        int r = (int)(rgb[0] * 255.0) & 0xFF;
        int g = (int)(rgb[1] * 255.0) & 0xFF;
        int b = (int)(rgb[2] * 255.0) & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public static double[] decodeRGB8(int rgb) {
        return new double[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    public void write(PacketBuffer buffer) {
        double[][] dArray = this.colours;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] colour;
            for (double channel : colour = dArray[i]) {
                buffer.writeByte((int)(channel * 255.0) & 0xFF);
            }
        }
    }

    public void read(PacketBuffer buffer) {
        for (int i = 0; i < 16; ++i) {
            double r = (double)(buffer.readByte() & 0xFF) / 255.0;
            double g = (double)(buffer.readByte() & 0xFF) / 255.0;
            double b = (double)(buffer.readByte() & 0xFF) / 255.0;
            this.setColour(i, r, g, b);
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        int[] rgb8 = new int[this.colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            rgb8[i] = Palette.encodeRGB8(this.colours[i]);
        }
        nbt.func_74783_a("term_palette", rgb8);
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("term_palette")) {
            return;
        }
        int[] rgb8 = nbt.func_74759_k("term_palette");
        if (rgb8.length != this.colours.length) {
            return;
        }
        for (int i = 0; i < this.colours.length; ++i) {
            double[] colours = Palette.decodeRGB8(rgb8[i]);
            this.setColour(i, colours[0], colours[1], colours[2]);
        }
    }
}

