/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import blusunrize.immersiveengineering.common.blocks.multiblocks.UnionMultiblock;
import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.client.gui.elements.GuiReactiveList;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;
import org.lwjgl.opengl.GL11;

public class ProjectorScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = new ResourceLocation("immersivepetroleum", "textures/gui/projector.png");
    static final ITextComponent GUI_CONFIRM = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.confirm");
    static final ITextComponent GUI_CANCEL = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.cancel");
    static final ITextComponent GUI_MIRROR = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.mirror");
    static final ITextComponent GUI_ROTATE_CW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rcw");
    static final ITextComponent GUI_ROTATE_CCW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rccw");
    static final ITextComponent GUI_UP = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.up");
    static final ITextComponent GUI_DOWN = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.down");
    static final ITextComponent GUI_SEARCH = ProjectorScreen.translation("gui.immersivepetroleum.projector.search");
    private int xSize = 256;
    private int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private Lazy<List<MultiblockHandler.IMultiblock>> multiblocks;
    private World templateWorld;
    private MultiblockHandler.IMultiblock multiblock;
    private GuiReactiveList list;
    private String[] listEntries;
    private SearchField searchField;
    Settings settings;
    Hand hand;
    float rotation = 0.0f;
    float move = 0.0f;

    public ProjectorScreen(Hand hand, ItemStack projector) {
        super((ITextComponent)new StringTextComponent("projector"));
        this.settings = new Settings(projector);
        this.hand = hand;
        this.multiblocks = Lazy.of(() -> MultiblockHandler.getMultiblocks());
        if (this.settings.getMultiblock() != null) {
            this.move = 20.0f;
        }
    }

    protected void func_231160_c_() {
        this.field_230708_k_ = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        this.field_230709_l_ = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.searchField = (SearchField)this.func_230480_a_((Widget)new SearchField(this.field_230712_o_, this.guiLeft + 25, this.guiTop + 13));
        this.func_230480_a_((Widget)new ConfirmButton(this.guiLeft + 115, this.guiTop + 10, but -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            this.settings.setMode(Settings.Mode.PROJECTION);
            ItemStack held = player.func_184586_b(this.hand);
            this.settings.applyTo(held);
            this.settings.sendPacketToServer(this.hand);
            Minecraft.func_71410_x().field_71462_r.func_231175_as__();
            player.func_146105_b(this.settings.getMode().getTranslated(), true);
        }));
        this.func_230480_a_((Widget)new CancelButton(this.guiLeft + 115, this.guiTop + 34, but -> Minecraft.func_71410_x().field_71462_r.func_231175_as__()));
        this.func_230480_a_((Widget)new MirrorButton(this.guiLeft + 115, this.guiTop + 58, this.settings, but -> this.settings.flip()));
        this.func_230480_a_((Widget)new RotateLeftButton(this.guiLeft + 115, this.guiTop + 106, but -> this.settings.rotateCCW()));
        this.func_230480_a_((Widget)new RotateRightButton(this.guiLeft + 115, this.guiTop + 130, but -> this.settings.rotateCW()));
        this.updatelist();
    }

    private void listaction(Button button) {
        GuiReactiveList l = (GuiReactiveList)button;
        if (l.selectedOption >= 0 && l.selectedOption < this.listEntries.length) {
            String str = this.listEntries[l.selectedOption];
            MultiblockHandler.IMultiblock mb = (MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(Integer.valueOf(str));
            this.settings.setMultiblock(mb);
        }
    }

    private void updatelist() {
        boolean exists = this.field_230710_m_.contains((Object)this.list);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ((List)this.multiblocks.get()).size(); ++i) {
            String name = ((MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(i)).getUniqueName().toString();
            if (name.contains("feedthrough")) continue;
            list.add(Integer.toString(i));
        }
        list.sort((a, b) -> {
            String nameA = this.getMBName(Integer.valueOf(a));
            String nameB = this.getMBName(Integer.valueOf(b));
            return nameA.compareToIgnoreCase(nameB);
        });
        list.removeIf(str -> {
            String name = this.getMBName(Integer.valueOf(str));
            return !name.toLowerCase().contains(this.searchField.func_146179_b().toLowerCase());
        });
        this.listEntries = list.toArray(new String[0]);
        GuiReactiveList guilist = new GuiReactiveList(this, this.guiLeft + 15, this.guiTop + 29, 89, 127, button -> this.listaction(button), this.listEntries);
        guilist.setPadding(1, 1, 1, 1);
        guilist.setTextColor(0);
        guilist.setTextHoverColor(0x7F7FFF);
        guilist.setTranslationFunc(str -> this.getMBName(Integer.valueOf(str)));
        if (!exists) {
            this.list = (GuiReactiveList)this.func_230480_a_((Widget)guilist);
            return;
        }
        int a2 = this.field_230710_m_.indexOf((Object)this.list);
        int b2 = this.field_230705_e_.indexOf((Object)this.list);
        this.list = guilist;
        if (a2 != -1) {
            this.field_230710_m_.set(a2, this.list);
        }
        if (b2 != -1) {
            this.field_230705_e_.set(b2, this.list);
        }
    }

    private String getMBName(int index) {
        MultiblockHandler.IMultiblock mb = (MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(index);
        if (mb instanceof UnionMultiblock && mb.getUniqueName().func_110623_a().contains("excavator_demo")) {
            return I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblock.IE:Excavator", (Object[])new Object[0]) + "2";
        }
        return I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock.IE:" + ProjectorItem.getActualMBName(mb)), (Object[])new Object[0]);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.settings.getMultiblock() != null) {
            MultiblockHandler.IMultiblock mb = this.settings.getMultiblock();
            int x = this.guiLeft + 28;
            int y = this.guiTop - (int)(15.0f * (this.move / 20.0f));
            if (this.move < 20.0f) {
                this.move = (float)((double)this.move + 1.5 * (double)partialTicks);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
            this.func_238474_b_(matrix, x, y, 0, 166, 200, 13);
            Object text = mb instanceof UnionMultiblock && this.settings.getMultiblock().getUniqueName().func_110623_a().contains("excavator_demo") ? new TranslationTextComponent("desc.immersiveengineering.info.multiblock.IE:Excavator").func_240702_b_("2") : new TranslationTextComponent("desc.immersiveengineering.info.multiblock.IE:" + ProjectorItem.getActualMBName(mb));
            IReorderingProcessor re = text.func_241878_f();
            this.field_230712_o_.func_238422_b_(matrix, re, (float)((x += 100) - this.field_230712_o_.func_243245_a(re) / 2), (float)(y += 3), 0x3F3F3F);
        }
        this.background(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.searchField.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX, mouseY);
            break;
        }
        int x = this.guiLeft + 115;
        int y = this.guiTop + 82;
        Direction dir = Direction.func_176731_b((int)this.settings.getRotation().ordinal());
        StringTextComponent dirText = new StringTextComponent(dir.toString().toUpperCase().substring(0, 1));
        ProjectorScreen.func_238472_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)dirText, (int)(x + 5), (int)(y + 1), (int)-1);
        if (mouseX > x && mouseX < x + 10 && mouseY > y && mouseY < y + 10) {
            TranslationTextComponent rotText = new TranslationTextComponent("desc.immersivepetroleum.info.projector.rotated." + dir);
            this.func_238652_a_(matrix, (ITextComponent)rotText, mouseX, mouseY);
        }
        if (this.settings.getMultiblock() != null) {
            MultiblockHandler.IMultiblock mb = this.settings.getMultiblock();
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            try {
                this.rotation += 1.5f * partialTicks;
                Vector3i size = mb.getSize(null);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(this.guiLeft + 190), (double)(this.guiTop + 80), 64.0);
                matrix.func_227862_a_(mb.getManualScale(), -mb.getManualScale(), 1.0f);
                matrix.func_227863_a_(new Quaternion(25.0f, 0.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)((int)(45.0f - this.rotation)), 0.0f, true));
                matrix.func_227861_a_((double)((float)size.func_177958_n() / -2.0f), (double)((float)size.func_177956_o() / -2.0f), (double)((float)size.func_177952_p() / -2.0f));
                boolean tempDisable = true;
                if (tempDisable && mb.canRenderFormedStructure()) {
                    matrix.func_227860_a_();
                    mb.renderFormedStructure(matrix, IPRenderTypes.disableLighting((IRenderTypeBuffer)buffer));
                    matrix.func_227865_b_();
                } else {
                    if (this.templateWorld == null || !this.multiblock.getUniqueName().equals((Object)mb.getUniqueName())) {
                        this.templateWorld = ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.getValue()).makeWorld(mb.getStructure(null), pos -> true);
                        this.multiblock = mb;
                    }
                    BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
                    int it = 0;
                    List infos = mb.getStructure(null);
                    for (Template.BlockInfo info : infos) {
                        if (info.field_186243_b.func_185904_a() == Material.field_151579_a || mb.overwriteBlockRender(info.field_186243_b, it++)) continue;
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)info.field_186242_a.func_177958_n(), (double)info.field_186242_a.func_177956_o(), (double)info.field_186242_a.func_177952_p());
                        int overlay = OverlayTexture.field_229196_a_;
                        EmptyModelData modelData = EmptyModelData.INSTANCE;
                        TileEntity te = this.templateWorld.func_175625_s(info.field_186242_a);
                        if (te != null) {
                            modelData = te.getModelData();
                        }
                        blockRender.renderBlock(info.field_186243_b, matrix, IPRenderTypes.disableLighting((IRenderTypeBuffer)buffer), 0xF000F0, overlay, (IModelData)modelData);
                        matrix.func_227865_b_();
                    }
                }
                matrix.func_227865_b_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            buffer.func_228461_a_();
        }
    }

    private void background(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrix, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers) || this.searchField.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return super.func_231042_a_(codePoint, modifiers) || this.searchField.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231177_au__() {
        return false;
    }

    static ITextComponent translation(String key) {
        return new TranslationTextComponent(key);
    }

    static class PButton
    extends AbstractButton {
        protected boolean selected;
        protected final int xOverlay;
        protected final int yOverlay;
        protected int iconSize = 10;
        protected int bgStartX = 0;
        protected int bgStartY = 166;
        protected Consumer<PButton> action;

        public PButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.action = action;
            this.xOverlay = overlayX;
            this.yOverlay = overlayY;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
            if (this.func_230449_g_()) {
                PButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.iconSize), (int)(this.field_230691_m_ + this.iconSize - 1), (int)-1350598657);
            }
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
        }

        public void func_230930_b_() {
            this.action.accept(this);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean isSelected) {
            this.selected = isSelected;
        }
    }

    class SearchField
    extends TextFieldWidget {
        public SearchField(FontRenderer font, int x, int y) {
            super(font, x, y, 60, 14, GUI_SEARCH);
            this.func_146203_f(50);
            this.func_146185_a(false);
            this.func_146189_e(true);
            this.func_146193_g(0xFFFFFF);
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            String s = this.func_146179_b();
            if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
                if (!Objects.equals(s, this.func_146179_b())) {
                    ProjectorScreen.this.updatelist();
                }
                return true;
            }
            return this.func_230999_j_() && this.func_146176_q() && keyCode != 256 ? true : super.func_231046_a_(keyCode, scanCode, modifiers);
        }

        public boolean func_231042_a_(char codePoint, int modifiers) {
            if (!this.func_230999_j_()) {
                this.func_231049_c__(true);
                this.func_146195_b(true);
            }
            String s = this.func_146179_b();
            if (super.func_231042_a_(codePoint, modifiers)) {
                if (!Objects.equals(s, this.func_146179_b())) {
                    ProjectorScreen.this.updatelist();
                }
                return true;
            }
            return false;
        }
    }

    class ControlButton
    extends PButton {
        ITextComponent hoverText;

        public ControlButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action, ITextComponent hoverText) {
            super(x, y, width, height, overlayX, overlayY, action);
            this.hoverText = hoverText;
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.hoverText != null) {
                ProjectorScreen.this.func_238652_a_(matrixStack, this.hoverText, mouseX, mouseY);
            }
        }
    }

    class RotateRightButton
    extends ControlButton {
        public RotateRightButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 40, 179, action, GUI_ROTATE_CW);
        }
    }

    class RotateLeftButton
    extends ControlButton {
        public RotateLeftButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 30, 179, action, GUI_ROTATE_CCW);
        }
    }

    class MirrorButton
    extends ControlButton {
        Settings settings;

        public MirrorButton(int x, int y, Settings settings, Consumer<PButton> action) {
            super(x, y, 10, 10, 20, 179, action, GUI_MIRROR);
            this.settings = settings;
        }

        @Override
        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
            if (this.func_230449_g_()) {
                MirrorButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.iconSize), (int)(this.field_230691_m_ + this.iconSize - 1), (int)-1350598657);
            }
            if (this.settings.isMirrored()) {
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.xOverlay, this.yOverlay + this.iconSize, this.iconSize, this.iconSize);
            } else {
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
            }
        }
    }

    class CancelButton
    extends ControlButton {
        public CancelButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 10, 179, action, GUI_CANCEL);
        }
    }

    class ConfirmButton
    extends ControlButton {
        public ConfirmButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 0, 179, action, GUI_CONFIRM);
        }
    }
}

