/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.cfg;

import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Preconditions;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="immersivepetroleum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPServerConfig {
    public static final Extraction EXTRACTION;
    public static final Refining REFINING;
    public static final Generation GENERATION;
    public static final Miscellaneous MISCELLANEOUS;
    public static final ForgeConfigSpec ALL;
    private static Config rawConfig;

    public static Config getRawConfig() {
        if (rawConfig == null) {
            try {
                Field childConfig = ForgeConfigSpec.class.getDeclaredField("childConfig");
                childConfig.setAccessible(true);
                rawConfig = (Config)childConfig.get(ALL);
                Preconditions.checkNotNull((Object)rawConfig);
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return rawConfig;
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.ModConfigEvent ev) {
        FuelHandler.onConfigReload(ev);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        EXTRACTION = new Extraction(builder);
        REFINING = new Refining(builder);
        GENERATION = new Generation(builder);
        MISCELLANEOUS = new Miscellaneous(builder);
        ALL = builder.build();
    }

    public static class Miscellaneous {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> boat_fuels;
        public final ForgeConfigSpec.BooleanValue autounlock_recipes;
        public final ForgeConfigSpec.BooleanValue asphalt_speed;

        Miscellaneous(ForgeConfigSpec.Builder builder) {
            builder.push("Miscellaneous");
            this.boat_fuels = builder.comment("List of Motorboat fuels. Format: fluid_name, mb_used_per_tick").defineList("boat_fuels", Arrays.asList("immersivepetroleum:gasoline, 1"), o -> true);
            this.autounlock_recipes = builder.comment(new String[]{"Automatically unlock IP recipes for new players", "Default: true"}).define("autounlock_recipes", true);
            this.asphalt_speed = builder.comment(new String[]{"Set to false to disable the asphalt block boosting player speed", "Default: true"}).define("asphalt_speed", true);
            builder.pop();
        }
    }

    public static class Generation {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> fuels;

        Generation(ForgeConfigSpec.Builder builder) {
            builder.push("Generation");
            this.fuels = builder.comment("List of Portable Generator fuels. Format: fluid_name, mb_used_per_tick, flux_produced_per_tick").defineList("fuels", Arrays.asList("immersivepetroleum:gasoline, 5, 256"), o -> true);
            builder.pop();
        }
    }

    public static class Refining {
        public final ForgeConfigSpec.ConfigValue<Double> distillationTower_energyModifier;
        public final ForgeConfigSpec.ConfigValue<Double> distillationTower_timeModifier;
        public final ForgeConfigSpec.ConfigValue<Double> cokerUnit_energyModifier;
        public final ForgeConfigSpec.ConfigValue<Double> cokerUnit_timeModifier;
        public final ForgeConfigSpec.ConfigValue<Double> hydrotreater_energyModifier;
        public final ForgeConfigSpec.ConfigValue<Double> hydrotreater_timeModifier;

        Refining(ForgeConfigSpec.Builder builder) {
            builder.push("Refining");
            this.distillationTower_energyModifier = builder.comment(new String[]{"A modifier to apply to the energy costs of every Distillation Tower recipe", "Default: 1.0"}).define("distillationTower_energyModifier", (Object)1.0);
            this.distillationTower_timeModifier = builder.comment(new String[]{"A modifier to apply to the time of every Distillation recipe. Can't be lower than 1", "Default: 1.0"}).define("distillationTower_timeModifier", (Object)1.0);
            this.cokerUnit_energyModifier = builder.comment(new String[]{"A modifier to apply to the energy costs of every Coker Tower recipe", "Default: 1.0"}).define("cokerUnit_energyModifier", (Object)1.0);
            this.cokerUnit_timeModifier = builder.comment(new String[]{"A modifier to apply to the time of every Coker recipe. Can't be lower than 1", "Default: 1.0"}).define("cokerUnit_timeModifier", (Object)1.0);
            this.hydrotreater_energyModifier = builder.comment(new String[]{"A modifier to apply to the energy costs of every Sulfur Recovery Unit recipe", "Default: 1.0"}).define("hydrotreater_energyModifier", (Object)1.0);
            this.hydrotreater_timeModifier = builder.comment(new String[]{"A modifier to apply to the time of every Sulfur Recovery Unit recipe. Can't be lower than 1", "Default: 1.0"}).define("hydrotreater_timeModifier", (Object)1.0);
            builder.pop();
        }
    }

    public static class Extraction {
        public final ForgeConfigSpec.ConfigValue<Double> reservoir_chance;
        public final ForgeConfigSpec.ConfigValue<Integer> pumpjack_consumption;
        public final ForgeConfigSpec.ConfigValue<Integer> pumpjack_speed;
        public final ForgeConfigSpec.ConfigValue<Integer> pipe_check_ticks;
        public final ForgeConfigSpec.BooleanValue required_pipes;

        Extraction(ForgeConfigSpec.Builder builder) {
            builder.push("Extraction");
            this.reservoir_chance = builder.comment(new String[]{"The chance that a chunk contains a fluid reservoir", "Default: 0.5"}).define("reservoir_chance", (Object)0.5);
            this.pumpjack_consumption = builder.comment(new String[]{"The Flux the Pumpjack requires each tick to pump", "Default: 1024"}).define("pumpjack_consumption", (Object)1024);
            this.pumpjack_speed = builder.comment(new String[]{"The amount of mB of oil a Pumpjack extracts per tick", "Default: 15"}).define("pumpjack_speed", (Object)15);
            this.required_pipes = builder.comment(new String[]{"Require a pumpjack to have pipes built down to Bedrock", "Default: false"}).define("req_pipes", false);
            this.pipe_check_ticks = builder.comment(new String[]{"Number of ticks between checking for pipes below pumpjack if required", "Default: 100"}).define("pipe_check_ticks", (Object)100);
            builder.pop();
        }
    }
}

